/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.interceptor;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.interceptor.AtomicOperationInvocation;
import io.openbpm.bpm.engine.impl.interceptor.ContextLogger;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BpmnStackTrace {
    private static final String ACTIVITY_ID = "activityId";
    private static final String ACTIVITY_NAME = "activityName";
    private static final ContextLogger LOG = ProcessEngineLogger.CONTEXT_LOGGER;
    protected List<AtomicOperationInvocation> perfromedInvocations = new ArrayList<AtomicOperationInvocation>();

    public void printStackTrace(boolean verbose) {
        if (this.perfromedInvocations.isEmpty()) {
            return;
        }
        StringWriter writer = new StringWriter();
        writer.write("BPMN Stack Trace:\n");
        if (!verbose) {
            this.logNonVerbose(writer);
        } else {
            this.logVerbose(writer);
        }
        LOG.bpmnStackTrace(writer.toString());
        this.perfromedInvocations.clear();
    }

    protected void logNonVerbose(StringWriter writer) {
        this.writeInvocation(this.perfromedInvocations.get(this.perfromedInvocations.size() - 1), writer);
        List<Map<String, String>> activityTrace = this.collectActivityTrace();
        this.logActivityTrace(writer, activityTrace);
    }

    protected void logVerbose(StringWriter writer) {
        Collections.reverse(this.perfromedInvocations);
        for (AtomicOperationInvocation invocation : this.perfromedInvocations) {
            this.writeInvocation(invocation, writer);
        }
    }

    protected void logActivityTrace(StringWriter writer, List<Map<String, String>> activities) {
        for (int i = 0; i < activities.size(); ++i) {
            if (i != 0) {
                writer.write("\t  ^\n");
                writer.write("\t  |\n");
            }
            writer.write("\t");
            Map<String, String> activity = activities.get(i);
            String activityId = activity.get(ACTIVITY_ID);
            writer.write(activityId);
            String activityName = activity.get(ACTIVITY_NAME);
            if (activityName != null) {
                writer.write(", name=");
                writer.write(activityName);
            }
            writer.write("\n");
        }
    }

    protected List<Map<String, String>> collectActivityTrace() {
        ArrayList<Map<String, String>> activityTrace = new ArrayList<Map<String, String>>();
        for (AtomicOperationInvocation atomicOperationInvocation : this.perfromedInvocations) {
            String activityId = atomicOperationInvocation.getActivityId();
            if (activityId == null) continue;
            HashMap<String, String> activity = new HashMap<String, String>();
            activity.put(ACTIVITY_ID, activityId);
            String activityName = atomicOperationInvocation.getActivityName();
            if (activityName != null) {
                activity.put(ACTIVITY_NAME, activityName);
            }
            if (!activityTrace.isEmpty() && ((String)activity.get(ACTIVITY_ID)).equals(((Map)activityTrace.get(0)).get(ACTIVITY_ID))) continue;
            activityTrace.add(0, activity);
        }
        return activityTrace;
    }

    public void add(AtomicOperationInvocation atomicOperationInvocation) {
        this.perfromedInvocations.add(atomicOperationInvocation);
    }

    protected void writeInvocation(AtomicOperationInvocation invocation, StringWriter writer) {
        writer.write("\t");
        writer.write(invocation.getActivityId());
        writer.write(" (");
        writer.write(invocation.getOperation().getCanonicalName());
        writer.write(", ");
        writer.write(invocation.getExecution().toString());
        if (invocation.isPerformAsync()) {
            writer.write(", ASYNC");
        }
        if (invocation.getApplicationContextName() != null) {
            writer.write(", pa=");
            writer.write(invocation.getApplicationContextName());
        }
        writer.write(")\n");
    }
}

