/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.DefaultPriorityProvider;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import io.openbpm.bpm.engine.impl.jobexecutor.JobDeclaration;
import io.openbpm.bpm.engine.impl.jobexecutor.JobExecutorLogger;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;

public class DefaultJobPriorityProvider
extends DefaultPriorityProvider<JobDeclaration<?, ?>> {
    private static final JobExecutorLogger LOG = ProcessEngineLogger.JOB_EXECUTOR_LOGGER;

    @Override
    protected Long getSpecificPriority(ExecutionEntity execution, JobDeclaration<?, ?> param, String jobDefinitionId) {
        ParameterValueProvider priorityProvider;
        Long specificPriority = null;
        JobDefinitionEntity jobDefinition = this.getJobDefinitionFor(jobDefinitionId);
        if (jobDefinition != null) {
            specificPriority = jobDefinition.getOverridingJobPriority();
        }
        if (specificPriority == null && (priorityProvider = param.getJobPriorityProvider()) != null) {
            specificPriority = this.evaluateValueProvider(priorityProvider, execution, this.describeContext(param, execution));
        }
        return specificPriority;
    }

    @Override
    protected Long getProcessDefinitionPriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        ProcessDefinitionImpl processDefinition = jobDeclaration.getProcessDefinition();
        return this.getProcessDefinedPriority(processDefinition, "jobPriority", execution, this.describeContext(jobDeclaration, execution));
    }

    protected JobDefinitionEntity getJobDefinitionFor(String jobDefinitionId) {
        if (jobDefinitionId != null) {
            return Context.getCommandContext().getJobDefinitionManager().findById(jobDefinitionId);
        }
        return null;
    }

    protected Long getActivityPriority(ExecutionEntity execution, JobDeclaration<?, ?> jobDeclaration) {
        ParameterValueProvider priorityProvider;
        if (jobDeclaration != null && (priorityProvider = jobDeclaration.getJobPriorityProvider()) != null) {
            return this.evaluateValueProvider(priorityProvider, execution, this.describeContext(jobDeclaration, execution));
        }
        return null;
    }

    @Override
    protected void logNotDeterminingPriority(ExecutionEntity execution, Object value, ProcessEngineException e) {
        LOG.couldNotDeterminePriority(execution, value, e);
    }

    protected String describeContext(JobDeclaration<?, ?> jobDeclaration, ExecutionEntity executionEntity) {
        return "Job " + jobDeclaration.getActivityId() + "/" + jobDeclaration.getJobHandlerType() + " instantiated in context of " + String.valueOf(executionEntity);
    }
}

