/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import io.openbpm.bpm.engine.impl.jobexecutor.JobDeclaration;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.jobexecutor.ProcessEventJobHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.MessageEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.commons.utils.EnsureUtil;
import java.util.Collections;
import java.util.List;

public class EventSubscriptionJobDeclaration
extends JobDeclaration<EventSubscriptionEntity, MessageEntity> {
    private static final long serialVersionUID = 1L;
    protected EventSubscriptionDeclaration eventSubscriptionDeclaration;

    public EventSubscriptionJobDeclaration(EventSubscriptionDeclaration eventSubscriptionDeclaration) {
        super("event");
        EnsureUtil.ensureNotNull((String)"eventSubscriptionDeclaration", (Object)eventSubscriptionDeclaration);
        this.eventSubscriptionDeclaration = eventSubscriptionDeclaration;
    }

    @Override
    protected MessageEntity newJobInstance(EventSubscriptionEntity eventSubscription) {
        MessageEntity message = new MessageEntity();
        message.setActivityId(eventSubscription.getActivityId());
        message.setExecutionId(eventSubscription.getExecutionId());
        message.setProcessInstanceId(eventSubscription.getProcessInstanceId());
        ProcessDefinitionEntity processDefinition = eventSubscription.getProcessDefinition();
        if (processDefinition != null) {
            message.setProcessDefinitionId(processDefinition.getId());
            message.setProcessDefinitionKey(processDefinition.getKey());
        }
        return message;
    }

    public String getEventType() {
        return this.eventSubscriptionDeclaration.getEventType();
    }

    public String getEventName() {
        return this.eventSubscriptionDeclaration.getUnresolvedEventName();
    }

    @Override
    public String getActivityId() {
        return this.eventSubscriptionDeclaration.getActivityId();
    }

    @Override
    protected ExecutionEntity resolveExecution(EventSubscriptionEntity context) {
        return context.getExecution();
    }

    @Override
    protected JobHandlerConfiguration resolveJobHandlerConfiguration(EventSubscriptionEntity context) {
        return new ProcessEventJobHandler.EventSubscriptionJobConfiguration(context.getId());
    }

    public static List<EventSubscriptionJobDeclaration> getDeclarationsForActivity(PvmActivity activity) {
        Object result = activity.getProperty("eventJobDeclarations");
        if (result != null) {
            return (List)result;
        }
        return Collections.emptyList();
    }

    public static EventSubscriptionJobDeclaration findDeclarationForSubscription(EventSubscriptionEntity eventSubscription) {
        List<EventSubscriptionJobDeclaration> declarations = EventSubscriptionJobDeclaration.getDeclarationsForActivity(eventSubscription.getActivity());
        for (EventSubscriptionJobDeclaration declaration : declarations) {
            if (!declaration.getEventType().equals(eventSubscription.getEventType())) continue;
            return declaration;
        }
        return null;
    }
}

