/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor;

import io.openbpm.bpm.engine.impl.cfg.TransactionListener;
import io.openbpm.bpm.engine.impl.interceptor.Command;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.TimerEntity;
import java.util.Date;

public class RepeatingFailedJobListener
implements TransactionListener {
    protected CommandExecutor commandExecutor;
    protected String jobId;

    public RepeatingFailedJobListener(CommandExecutor commandExecutor, String jobId) {
        this.commandExecutor = commandExecutor;
        this.jobId = jobId;
    }

    @Override
    public void execute(CommandContext commandContext) {
        CreateNewTimerJobCommand cmd = new CreateNewTimerJobCommand(this.jobId);
        this.commandExecutor.execute(cmd);
    }

    protected class CreateNewTimerJobCommand
    implements Command<Void> {
        protected String jobId;

        public CreateNewTimerJobCommand(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public Void execute(CommandContext commandContext) {
            TimerEntity failedJob = (TimerEntity)commandContext.getJobManager().findJobById(this.jobId);
            Date newDueDate = failedJob.calculateNewDueDate();
            if (newDueDate != null) {
                failedJob.createNewTimerJob(newDueDate);
                TimerEventJobHandler.TimerJobConfiguration config = (TimerEventJobHandler.TimerJobConfiguration)failedJob.getJobHandlerConfiguration();
                config.setFollowUpJobCreated(true);
                failedJob.setJobHandlerConfiguration(config);
            }
            return null;
        }
    }
}

