/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor.historycleanup;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import io.openbpm.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.jobexecutor.JobDeclaration;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupContext;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.persistence.entity.EverLivingJobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import java.util.Date;

public class HistoryCleanupJobDeclaration
extends JobDeclaration<HistoryCleanupContext, EverLivingJobEntity> {
    public HistoryCleanupJobDeclaration() {
        super("history-cleanup");
    }

    @Override
    protected ExecutionEntity resolveExecution(HistoryCleanupContext context) {
        return null;
    }

    @Override
    protected EverLivingJobEntity newJobInstance(HistoryCleanupContext context) {
        return new EverLivingJobEntity();
    }

    @Override
    protected void postInitialize(HistoryCleanupContext context, EverLivingJobEntity job) {
    }

    @Override
    public EverLivingJobEntity reconfigure(HistoryCleanupContext context, EverLivingJobEntity job) {
        HistoryCleanupJobHandlerConfiguration configuration = this.resolveJobHandlerConfiguration(context);
        job.setJobHandlerConfiguration(configuration);
        return job;
    }

    protected HistoryCleanupJobHandlerConfiguration resolveJobHandlerConfiguration(HistoryCleanupContext context) {
        HistoryCleanupJobHandlerConfiguration config = new HistoryCleanupJobHandlerConfiguration();
        config.setImmediatelyDue(context.isImmediatelyDue());
        config.setMinuteFrom(context.getMinuteFrom());
        config.setMinuteTo(context.getMinuteTo());
        return config;
    }

    @Override
    protected int resolveRetries(HistoryCleanupContext context) {
        return context.getMaxRetries();
    }

    @Override
    public Date resolveDueDate(HistoryCleanupContext context) {
        return this.resolveDueDate(context.isImmediatelyDue());
    }

    @Override
    private Date resolveDueDate(boolean isImmediatelyDue) {
        CommandContext commandContext = Context.getCommandContext();
        if (isImmediatelyDue) {
            return ClockUtil.getCurrentTime();
        }
        BatchWindow currentOrNextBatchWindow = commandContext.getProcessEngineConfiguration().getBatchWindowManager().getCurrentOrNextBatchWindow(ClockUtil.getCurrentTime(), commandContext.getProcessEngineConfiguration());
        if (currentOrNextBatchWindow != null) {
            return currentOrNextBatchWindow.getStart();
        }
        return null;
    }

    @Override
    public ParameterValueProvider getJobPriorityProvider() {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        long historyCleanupJobPriority = configuration.getHistoryCleanupJobPriority();
        return new ConstantValueProvider(historyCleanupJobPriority);
    }
}

