/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.jobexecutor.historycleanup;

import io.openbpm.bpm.engine.impl.cfg.TransactionState;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.engine.impl.jobexecutor.JobHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupBatch;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHandler;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupHelper;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import io.openbpm.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupRemovalTime;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import openbpmjar.impl.com.google.gson.JsonObject;

public class HistoryCleanupJobHandler
implements JobHandler<HistoryCleanupJobHandlerConfiguration> {
    public static final String TYPE = "history-cleanup";

    @Override
    public void execute(HistoryCleanupJobHandlerConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        HistoryCleanupHandler cleanupHandler = this.initCleanupHandler(configuration, commandContext);
        if (configuration.isImmediatelyDue() || this.isWithinBatchWindow(commandContext)) {
            cleanupHandler.performCleanup();
        }
        commandContext.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, cleanupHandler);
    }

    protected HistoryCleanupRemovalTime getTimeBasedHandler() {
        return new HistoryCleanupRemovalTime();
    }

    protected HistoryCleanupHandler initCleanupHandler(HistoryCleanupJobHandlerConfiguration configuration, CommandContext commandContext) {
        HistoryCleanupHandler cleanupHandler = this.isHistoryCleanupStrategyRemovalTimeBased(commandContext) ? this.getTimeBasedHandler() : new HistoryCleanupBatch();
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew();
        String jobId = commandContext.getCurrentJob().getId();
        return cleanupHandler.setConfiguration(configuration).setCommandExecutor(commandExecutor).setJobId(jobId);
    }

    protected boolean isHistoryCleanupStrategyRemovalTimeBased(CommandContext commandContext) {
        String historyRemovalTimeStrategy = commandContext.getProcessEngineConfiguration().getHistoryCleanupStrategy();
        return "removalTimeBased".equals(historyRemovalTimeStrategy);
    }

    protected boolean isWithinBatchWindow(CommandContext commandContext) {
        return HistoryCleanupHelper.isWithinBatchWindow(ClockUtil.getCurrentTime(), commandContext.getProcessEngineConfiguration());
    }

    @Override
    public HistoryCleanupJobHandlerConfiguration newConfiguration(String canonicalString) {
        JsonObject jsonObject = JsonUtil.asObject(canonicalString);
        return HistoryCleanupJobHandlerConfiguration.fromJson(jsonObject);
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

