/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.json;

import io.openbpm.bpm.engine.impl.QueryEntityRelationCondition;
import io.openbpm.bpm.engine.impl.QueryPropertyImpl;
import io.openbpm.bpm.engine.impl.json.JsonArrayConverter;
import io.openbpm.bpm.engine.impl.json.JsonArrayOfObjectsConverter;
import io.openbpm.bpm.engine.impl.json.JsonObjectConverter;
import io.openbpm.bpm.engine.impl.util.JsonUtil;
import io.openbpm.bpm.engine.query.QueryProperty;
import java.util.List;
import openbpmjar.impl.com.google.gson.JsonObject;

public class JsonQueryFilteringPropertyConverter
extends JsonObjectConverter<QueryEntityRelationCondition> {
    protected static final JsonQueryFilteringPropertyConverter INSTANCE = new JsonQueryFilteringPropertyConverter();
    protected static final JsonArrayConverter<List<QueryEntityRelationCondition>> ARRAY_CONVERTER = new JsonArrayOfObjectsConverter<QueryEntityRelationCondition>(INSTANCE);
    public static final String BASE_PROPERTY = "baseField";
    public static final String COMPARISON_PROPERTY = "comparisonField";
    public static final String SCALAR_VALUE = "value";

    @Override
    public JsonObject toJsonObject(QueryEntityRelationCondition filteringProperty) {
        Object scalarValue;
        JsonObject jsonObject = JsonUtil.createObject();
        JsonUtil.addField(jsonObject, BASE_PROPERTY, filteringProperty.getProperty().getName());
        QueryProperty comparisonProperty = filteringProperty.getComparisonProperty();
        if (comparisonProperty != null) {
            JsonUtil.addField(jsonObject, COMPARISON_PROPERTY, comparisonProperty.getName());
        }
        if ((scalarValue = filteringProperty.getScalarValue()) != null) {
            JsonUtil.addFieldRawValue(jsonObject, SCALAR_VALUE, scalarValue);
        }
        return jsonObject;
    }

    @Override
    public QueryEntityRelationCondition toObject(JsonObject jsonObject) {
        String scalarValue = null;
        if (jsonObject.has(SCALAR_VALUE)) {
            scalarValue = JsonUtil.getString(jsonObject, SCALAR_VALUE);
        }
        QueryPropertyImpl baseProperty = null;
        if (jsonObject.has(BASE_PROPERTY)) {
            baseProperty = new QueryPropertyImpl(JsonUtil.getString(jsonObject, BASE_PROPERTY));
        }
        QueryPropertyImpl comparisonProperty = null;
        if (jsonObject.has(COMPARISON_PROPERTY)) {
            comparisonProperty = new QueryPropertyImpl(JsonUtil.getString(jsonObject, COMPARISON_PROPERTY));
        }
        return new QueryEntityRelationCondition(baseProperty, comparisonProperty, scalarValue);
    }
}

