/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationPlanValidationReportImpl;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.migration.MigratingProcessInstanceValidationException;
import io.openbpm.bpm.engine.migration.MigrationPlanValidationException;

public class MigrationLogger
extends ProcessEngineLogger {
    public MigrationPlanValidationException failingMigrationPlanValidation(MigrationPlanValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigrationPlanValidationException(this.exceptionMessage("001", "{}", new Object[]{sb.toString()}), validationReport);
    }

    public ProcessEngineException processDefinitionOfInstanceDoesNotMatchMigrationPlan(ExecutionEntity processInstance, String processDefinitionId) {
        return new ProcessEngineException(this.exceptionMessage("002", "Process instance '{}' cannot be migrated. Its process definition '{}' does not match the source process definition of the migration plan '{}'", new Object[]{processInstance.getId(), processInstance.getProcessDefinitionId(), processDefinitionId}));
    }

    public ProcessEngineException processInstanceDoesNotExist(String processInstanceId) {
        return new ProcessEngineException(this.exceptionMessage("003", "Process instance '{}' cannot be migrated. The process instance does not exist", new Object[]{processInstanceId}));
    }

    public MigratingProcessInstanceValidationException failingMigratingProcessInstanceValidation(MigratingProcessInstanceValidationReportImpl validationReport) {
        StringBuilder sb = new StringBuilder();
        validationReport.writeTo(sb);
        return new MigratingProcessInstanceValidationException(this.exceptionMessage("004", "{}", new Object[]{sb.toString()}), validationReport);
    }

    public ProcessEngineException cannotBecomeSubordinateInNonScope(MigratingActivityInstance activityInstance) {
        return new ProcessEngineException(this.exceptionMessage("005", "{}", new Object[]{"Cannot attach a subordinate to activity instance '{}'. Activity '{}' is not a scope", activityInstance.getActivityInstance().getId(), activityInstance.getActivityInstance().getActivityId()}));
    }

    public ProcessEngineException cannotDestroySubordinateInNonScope(MigratingActivityInstance activityInstance) {
        return new ProcessEngineException(this.exceptionMessage("006", "{}", new Object[]{"Cannot destroy a subordinate of activity instance '{}'. Activity '{}' is not a scope", activityInstance.getActivityInstance().getId(), activityInstance.getActivityInstance().getActivityId()}));
    }

    public ProcessEngineException cannotAttachToTransitionInstance(MigratingInstance attachingInstance) {
        return new ProcessEngineException(this.exceptionMessage("007", "{}", new Object[]{"Cannot attach instance '{}' to a transition instance", attachingInstance}));
    }

    public BadUserRequestException processDefinitionDoesNotExist(String processDefinitionId, String type) {
        return new BadUserRequestException(this.exceptionMessage("008", "{} process definition with id '{}' does not exist", new Object[]{type, processDefinitionId}));
    }

    public ProcessEngineException cannotMigrateBetweenTenants(String sourceTenantId, String targetTenantId) {
        return new ProcessEngineException(this.exceptionMessage("09", "Cannot migrate process instances between processes of different tenants ('{}' != '{}')", new Object[]{sourceTenantId, targetTenantId}));
    }

    public ProcessEngineException cannotMigrateInstanceBetweenTenants(String processInstanceId, String sourceTenantId, String targetTenantId) {
        String detailMessage = null;
        detailMessage = sourceTenantId != null ? this.exceptionMessage("010", "Cannot migrate process instance '{}' to a process definition of a different tenant ('{}' != '{}')", new Object[]{processInstanceId, sourceTenantId, targetTenantId}) : this.exceptionMessage("010", "Cannot migrate process instance '{}' without tenant to a process definition with a tenant ('{}')", new Object[]{processInstanceId, targetTenantId});
        return new ProcessEngineException(detailMessage);
    }

    public ProcessEngineException cannotHandleChild(MigratingScopeInstance scopeInstance, MigratingProcessElementInstance childCandidate) {
        return new ProcessEngineException(this.exceptionMessage("011", "Scope instance of type {} cannot have child of type {}", new Object[]{scopeInstance.getClass().getSimpleName(), childCandidate.getClass().getSimpleName()}));
    }
}

