/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.tree.TreeVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DeleteUnmappedInstanceVisitor
implements TreeVisitor<MigratingScopeInstance> {
    protected Set<MigratingScopeInstance> visitedInstances = new HashSet<MigratingScopeInstance>();
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    public DeleteUnmappedInstanceVisitor(boolean skipCustomListeners, boolean skipIoMappings) {
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
    }

    @Override
    public void visit(MigratingScopeInstance currentInstance) {
        this.visitedInstances.add(currentInstance);
        if (!currentInstance.migrates()) {
            HashSet<MigratingProcessElementInstance> children = new HashSet<MigratingProcessElementInstance>(currentInstance.getChildren());
            MigratingScopeInstance parent = currentInstance.getParent();
            currentInstance.detachChildren();
            currentInstance.remove(this.skipCustomListeners, this.skipIoMappings);
            for (MigratingProcessElementInstance child : children) {
                child.attachState(parent);
            }
        } else {
            currentInstance.removeUnmappedDependentInstances();
        }
    }

    public boolean hasVisitedAll(Collection<MigratingScopeInstance> activityInstances) {
        return this.visitedInstances.containsAll(activityInstances);
    }
}

