/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.migration.MigrationLogger;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.RemovingInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.migration.MigrationInstruction;

public class MigratingCompensationEventSubscriptionInstance
extends MigratingProcessElementInstance
implements RemovingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected EventSubscriptionEntity eventSubscription;

    public MigratingCompensationEventSubscriptionInstance(MigrationInstruction migrationInstruction, ScopeImpl sourceScope, ScopeImpl targetScope, EventSubscriptionEntity eventSubscription) {
        this.migrationInstruction = migrationInstruction;
        this.eventSubscription = eventSubscription;
        this.sourceScope = sourceScope;
        this.targetScope = targetScope;
        this.currentScope = sourceScope;
    }

    @Override
    public boolean isDetached() {
        return this.eventSubscription.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.eventSubscription.setExecution(null);
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateState() {
        this.eventSubscription.setActivity((ActivityImpl)this.targetScope);
        this.currentScope = this.targetScope;
    }

    @Override
    public void migrateDependentEntities() {
    }

    @Override
    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
    }

    @Override
    public ExecutionEntity resolveRepresentativeExecution() {
        return null;
    }

    @Override
    public void attachState(MigratingScopeInstance targetActivityInstance) {
        this.setParent(targetActivityInstance);
        ExecutionEntity representativeExecution = targetActivityInstance.resolveRepresentativeExecution();
        this.eventSubscription.setExecution(representativeExecution);
    }

    @Override
    public void setParent(MigratingScopeInstance parentInstance) {
        if (this.parentInstance != null) {
            this.parentInstance.removeChild(this);
        }
        this.parentInstance = parentInstance;
        if (parentInstance != null) {
            parentInstance.addChild(this);
        }
    }

    @Override
    public void remove() {
        this.eventSubscription.delete();
    }
}

