/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import io.openbpm.bpm.engine.impl.migration.MigrationLogger;
import io.openbpm.bpm.engine.impl.migration.instance.EmergingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.RemovingInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;

public class MigratingEventSubscriptionInstance
implements MigratingInstance,
RemovingInstance,
EmergingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected EventSubscriptionEntity eventSubscriptionEntity;
    protected ScopeImpl targetScope;
    protected boolean updateEvent;
    protected EventSubscriptionDeclaration targetDeclaration;
    protected EventSubscriptionDeclaration eventSubscriptionDeclaration;

    public MigratingEventSubscriptionInstance(EventSubscriptionEntity eventSubscriptionEntity, ScopeImpl targetScope, boolean updateEvent, EventSubscriptionDeclaration targetDeclaration) {
        this.eventSubscriptionEntity = eventSubscriptionEntity;
        this.targetScope = targetScope;
        this.updateEvent = updateEvent;
        this.targetDeclaration = targetDeclaration;
    }

    public MigratingEventSubscriptionInstance(EventSubscriptionEntity eventSubscriptionEntity) {
        this(eventSubscriptionEntity, null, false, null);
    }

    public MigratingEventSubscriptionInstance(EventSubscriptionDeclaration eventSubscriptionDeclaration) {
        this.eventSubscriptionDeclaration = eventSubscriptionDeclaration;
    }

    @Override
    public boolean isDetached() {
        return this.eventSubscriptionEntity.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.eventSubscriptionEntity.setExecution(null);
    }

    @Override
    public void attachState(MigratingScopeInstance newOwningInstance) {
        this.eventSubscriptionEntity.setExecution(newOwningInstance.resolveRepresentativeExecution());
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateState() {
        if (this.updateEvent) {
            this.targetDeclaration.updateSubscription(this.eventSubscriptionEntity);
        }
        this.eventSubscriptionEntity.setActivity((ActivityImpl)this.targetScope);
    }

    @Override
    public void migrateDependentEntities() {
    }

    @Override
    public void create(ExecutionEntity scopeExecution) {
        this.eventSubscriptionDeclaration.createSubscriptionForExecution(scopeExecution);
    }

    @Override
    public void remove() {
        this.eventSubscriptionEntity.delete();
    }
}

