/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance;

import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.RemovingInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import java.util.ArrayList;
import java.util.List;

public abstract class MigratingJobInstance
implements MigratingInstance,
RemovingInstance {
    protected JobEntity jobEntity;
    protected JobDefinitionEntity targetJobDefinitionEntity;
    protected ScopeImpl targetScope;
    protected List<MigratingInstance> migratingDependentInstances = new ArrayList<MigratingInstance>();

    protected MigratingJobInstance(JobEntity jobEntity, JobDefinitionEntity jobDefinitionEntity, ScopeImpl targetScope) {
        this.jobEntity = jobEntity;
        this.targetJobDefinitionEntity = jobDefinitionEntity;
        this.targetScope = targetScope;
    }

    protected MigratingJobInstance(JobEntity jobEntity) {
        this(jobEntity, null, null);
    }

    public JobEntity getJobEntity() {
        return this.jobEntity;
    }

    public void addMigratingDependentInstance(MigratingInstance migratingInstance) {
        this.migratingDependentInstances.add(migratingInstance);
    }

    @Override
    public boolean isDetached() {
        return this.jobEntity.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.jobEntity.setExecution(null);
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.detachState();
        }
    }

    @Override
    public void attachState(MigratingScopeInstance newOwningInstance) {
        this.attachTo(newOwningInstance.resolveRepresentativeExecution());
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(newOwningInstance);
        }
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        this.attachTo(targetTransitionInstance.resolveRepresentativeExecution());
        for (MigratingInstance dependentInstance : this.migratingDependentInstances) {
            dependentInstance.attachState(targetTransitionInstance);
        }
    }

    protected void attachTo(ExecutionEntity execution) {
        this.jobEntity.setExecution(execution);
    }

    @Override
    public void migrateState() {
        String activityId = this.targetScope.getId();
        this.jobEntity.setActivityId(activityId);
        this.migrateJobHandlerConfiguration();
        if (this.targetJobDefinitionEntity != null) {
            this.jobEntity.setJobDefinition(this.targetJobDefinitionEntity);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.targetScope.getProcessDefinition();
        this.jobEntity.setProcessDefinitionId(processDefinition.getId());
        this.jobEntity.setProcessDefinitionKey(processDefinition.getKey());
        this.jobEntity.setDeploymentId(processDefinition.getDeploymentId());
    }

    @Override
    public void migrateDependentEntities() {
        for (MigratingInstance migratingDependentInstance : this.migratingDependentInstances) {
            migratingDependentInstance.migrateState();
        }
    }

    @Override
    public void remove() {
        this.jobEntity.delete();
    }

    public boolean migrates() {
        return this.targetScope != null;
    }

    public ScopeImpl getTargetScope() {
        return this.targetScope;
    }

    public JobDefinitionEntity getTargetJobDefinitionEntity() {
        return this.targetJobDefinitionEntity;
    }

    protected abstract void migrateJobHandlerConfiguration();
}

