/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.tree.ReferenceWalker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CompensationEventSubscriptionWalker
extends ReferenceWalker<EventSubscriptionEntity> {
    public CompensationEventSubscriptionWalker(Collection<MigratingActivityInstance> collection) {
        super(CompensationEventSubscriptionWalker.collectCompensationEventSubscriptions(collection));
    }

    protected static List<EventSubscriptionEntity> collectCompensationEventSubscriptions(Collection<MigratingActivityInstance> activityInstances) {
        ArrayList<EventSubscriptionEntity> eventSubscriptions = new ArrayList<EventSubscriptionEntity>();
        for (MigratingActivityInstance activityInstance : activityInstances) {
            if (!activityInstance.getSourceScope().isScope()) continue;
            ExecutionEntity scopeExecution = activityInstance.resolveRepresentativeExecution();
            eventSubscriptions.addAll(scopeExecution.getCompensateEventSubscriptions());
        }
        return eventSubscriptions;
    }

    @Override
    protected Collection<EventSubscriptionEntity> nextElements() {
        EventSubscriptionEntity eventSubscriptionEntity = (EventSubscriptionEntity)this.getCurrentElement();
        ExecutionEntity compensatingExecution = CompensationUtil.getCompensatingExecution(eventSubscriptionEntity);
        if (compensatingExecution != null) {
            return compensatingExecution.getCompensateEventSubscriptions();
        }
        return Collections.emptyList();
    }
}

