/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.bpmn.helper.CompensationUtil;
import io.openbpm.bpm.engine.impl.core.model.Properties;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.migration.MigrationInstruction;
import java.util.ArrayList;

public class CompensationInstanceHandler
implements MigratingInstanceParseHandler<EventSubscriptionEntity> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, EventSubscriptionEntity element) {
        MigratingProcessElementInstance migratingInstance = element.getConfiguration() != null ? this.createMigratingEventScopeInstance(parseContext, element) : this.createMigratingEventSubscriptionInstance(parseContext, element);
        ExecutionEntity owningExecution = element.getExecution();
        MigratingScopeInstance parentInstance = null;
        parentInstance = owningExecution.isEventScope() ? parseContext.getMigratingCompensationInstanceByExecutionId(owningExecution.getId()) : parseContext.getMigratingActivityInstanceById(owningExecution.getParentActivityInstanceId());
        migratingInstance.setParent(parentInstance);
    }

    protected MigratingProcessElementInstance createMigratingEventSubscriptionInstance(MigratingInstanceParseContext parseContext, EventSubscriptionEntity element) {
        ActivityImpl compensationHandler = parseContext.getSourceProcessDefinition().findActivity(element.getActivityId());
        MigrationInstruction migrationInstruction = this.getMigrationInstruction(parseContext, compensationHandler);
        ActivityImpl targetScope = null;
        if (migrationInstruction != null) {
            ActivityImpl targetEventScope = (ActivityImpl)parseContext.getTargetActivity(migrationInstruction).getEventScope();
            targetScope = targetEventScope.findCompensationHandler();
        }
        MigratingCompensationEventSubscriptionInstance migratingCompensationInstance = parseContext.getMigratingProcessInstance().addCompensationSubscriptionInstance(migrationInstruction, element, compensationHandler, targetScope);
        parseContext.consume(element);
        return migratingCompensationInstance;
    }

    protected MigratingProcessElementInstance createMigratingEventScopeInstance(MigratingInstanceParseContext parseContext, EventSubscriptionEntity element) {
        ActivityImpl compensatingActivity = parseContext.getSourceProcessDefinition().findActivity(element.getActivityId());
        MigrationInstruction migrationInstruction = this.getMigrationInstruction(parseContext, compensatingActivity);
        ActivityImpl eventSubscriptionTargetScope = null;
        if (migrationInstruction != null) {
            if (compensatingActivity.isCompensationHandler()) {
                ActivityImpl targetEventScope = (ActivityImpl)parseContext.getTargetActivity(migrationInstruction).getEventScope();
                eventSubscriptionTargetScope = targetEventScope.findCompensationHandler();
            } else {
                eventSubscriptionTargetScope = parseContext.getTargetActivity(migrationInstruction);
            }
        }
        ExecutionEntity eventScopeExecution = CompensationUtil.getCompensatingExecution(element);
        MigrationInstruction eventScopeInstruction = parseContext.findSingleMigrationInstruction(eventScopeExecution.getActivityId());
        ActivityImpl targetScope = parseContext.getTargetActivity(eventScopeInstruction);
        MigratingEventScopeInstance migratingCompensationInstance = parseContext.getMigratingProcessInstance().addEventScopeInstance(eventScopeInstruction, eventScopeExecution, eventScopeExecution.getActivity(), targetScope, migrationInstruction, element, compensatingActivity, eventSubscriptionTargetScope);
        parseContext.consume(element);
        parseContext.submit(migratingCompensationInstance);
        this.parseDependentEntities(parseContext, migratingCompensationInstance);
        return migratingCompensationInstance;
    }

    protected MigrationInstruction getMigrationInstruction(MigratingInstanceParseContext parseContext, ActivityImpl activity) {
        if (activity.isCompensationHandler()) {
            Properties compensationHandlerProperties = activity.getProperties();
            ActivityImpl eventTrigger = compensationHandlerProperties.get(BpmnProperties.COMPENSATION_BOUNDARY_EVENT);
            if (eventTrigger == null) {
                eventTrigger = compensationHandlerProperties.get(BpmnProperties.INITIAL_ACTIVITY);
            }
            return parseContext.findSingleMigrationInstruction(eventTrigger.getActivityId());
        }
        return parseContext.findSingleMigrationInstruction(activity.getActivityId());
    }

    protected void parseDependentEntities(MigratingInstanceParseContext parseContext, MigratingEventScopeInstance migratingInstance) {
        ExecutionEntity representativeExecution = migratingInstance.resolveRepresentativeExecution();
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>(representativeExecution.getVariablesInternal());
        parseContext.handleDependentVariables(migratingInstance, variables);
    }
}

