/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.parser.ActivityInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.ActivityInstanceJobHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.ActivityInstanceWalker;
import io.openbpm.bpm.engine.impl.migration.instance.parser.CompensationEventSubscriptionWalker;
import io.openbpm.bpm.engine.impl.migration.instance.parser.CompensationInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.EventSubscriptionInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.IncidentInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingDependentInstanceParseHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.TransitionInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.TransitionInstanceJobHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.VariableInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.IncidentEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.migration.MigrationPlan;
import io.openbpm.bpm.engine.runtime.ActivityInstance;
import io.openbpm.bpm.engine.runtime.TransitionInstance;
import java.util.List;

public class MigratingInstanceParser {
    protected ProcessEngine engine;
    protected MigratingInstanceParseHandler<ActivityInstance> activityInstanceHandler = new ActivityInstanceHandler();
    protected MigratingInstanceParseHandler<TransitionInstance> transitionInstanceHandler = new TransitionInstanceHandler();
    protected MigratingInstanceParseHandler<EventSubscriptionEntity> compensationInstanceHandler = new CompensationInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> dependentActivityInstanceJobHandler = new ActivityInstanceJobHandler();
    protected MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> dependentTransitionInstanceJobHandler = new TransitionInstanceJobHandler();
    protected MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> dependentEventSubscriptionHandler = new EventSubscriptionInstanceHandler();
    protected MigratingDependentInstanceParseHandler<MigratingProcessElementInstance, List<VariableInstanceEntity>> dependentVariableHandler = new VariableInstanceHandler();
    protected MigratingInstanceParseHandler<IncidentEntity> incidentHandler = new IncidentInstanceHandler();

    public MigratingInstanceParser(ProcessEngine engine) {
        this.engine = engine;
    }

    public MigratingProcessInstance parse(String processInstanceId, MigrationPlan migrationPlan, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        CommandContext commandContext = Context.getCommandContext();
        List<EventSubscriptionEntity> eventSubscriptions = this.fetchEventSubscriptions(commandContext, processInstanceId);
        List<ExecutionEntity> executions = this.fetchExecutions(commandContext, processInstanceId);
        List<ExternalTaskEntity> externalTasks = this.fetchExternalTasks(commandContext, processInstanceId);
        List<IncidentEntity> incidents = this.fetchIncidents(commandContext, processInstanceId);
        List<JobEntity> jobs = this.fetchJobs(commandContext, processInstanceId);
        List<TaskEntity> tasks = this.fetchTasks(commandContext, processInstanceId);
        List<VariableInstanceEntity> variables = this.fetchVariables(commandContext, processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(processInstanceId);
        processInstance.restoreProcessInstance(executions, eventSubscriptions, variables, tasks, jobs, incidents, externalTasks);
        ProcessDefinitionEntity targetProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(migrationPlan.getTargetProcessDefinitionId());
        List<JobDefinitionEntity> targetJobDefinitions = this.fetchJobDefinitions(commandContext, targetProcessDefinition.getId());
        MigratingInstanceParseContext parseContext = new MigratingInstanceParseContext(this, migrationPlan, processInstance, targetProcessDefinition).eventSubscriptions(eventSubscriptions).externalTasks(externalTasks).incidents(incidents).jobs(jobs).tasks(tasks).targetJobDefinitions(targetJobDefinitions).variables(variables);
        ActivityInstance activityInstance = this.engine.getRuntimeService().getActivityInstance(processInstanceId);
        ActivityInstanceWalker activityInstanceWalker = new ActivityInstanceWalker(activityInstance);
        activityInstanceWalker.addPreVisitor(obj -> this.activityInstanceHandler.handle(parseContext, (ActivityInstance)obj));
        activityInstanceWalker.walkWhile();
        CompensationEventSubscriptionWalker compensateSubscriptionsWalker = new CompensationEventSubscriptionWalker(parseContext.getMigratingActivityInstances());
        compensateSubscriptionsWalker.addPreVisitor(obj -> this.compensationInstanceHandler.handle(parseContext, (EventSubscriptionEntity)obj));
        compensateSubscriptionsWalker.walkWhile();
        for (IncidentEntity incidentEntity : incidents) {
            this.incidentHandler.handle(parseContext, incidentEntity);
        }
        parseContext.validateNoEntitiesLeft(processInstanceReport);
        return parseContext.getMigratingProcessInstance();
    }

    public MigratingInstanceParseHandler<ActivityInstance> getActivityInstanceHandler() {
        return this.activityInstanceHandler;
    }

    public MigratingInstanceParseHandler<TransitionInstance> getTransitionInstanceHandler() {
        return this.transitionInstanceHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<EventSubscriptionEntity>> getDependentEventSubscriptionHandler() {
        return this.dependentEventSubscriptionHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingActivityInstance, List<JobEntity>> getDependentActivityInstanceJobHandler() {
        return this.dependentActivityInstanceJobHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingTransitionInstance, List<JobEntity>> getDependentTransitionInstanceJobHandler() {
        return this.dependentTransitionInstanceJobHandler;
    }

    public MigratingInstanceParseHandler<IncidentEntity> getIncidentHandler() {
        return this.incidentHandler;
    }

    public MigratingDependentInstanceParseHandler<MigratingProcessElementInstance, List<VariableInstanceEntity>> getDependentVariablesHandler() {
        return this.dependentVariableHandler;
    }

    protected List<ExecutionEntity> fetchExecutions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getExecutionManager().findExecutionsByProcessInstanceId(processInstanceId);
    }

    protected List<EventSubscriptionEntity> fetchEventSubscriptions(CommandContext commandContext, String processInstanceId) {
        return commandContext.getEventSubscriptionManager().findEventSubscriptionsByProcessInstanceId(processInstanceId);
    }

    protected List<ExternalTaskEntity> fetchExternalTasks(CommandContext commandContext, String processInstanceId) {
        return commandContext.getExternalTaskManager().findExternalTasksByProcessInstanceId(processInstanceId);
    }

    protected List<JobEntity> fetchJobs(CommandContext commandContext, String processInstanceId) {
        return commandContext.getJobManager().findJobsByProcessInstanceId(processInstanceId);
    }

    protected List<IncidentEntity> fetchIncidents(CommandContext commandContext, String processInstanceId) {
        return commandContext.getIncidentManager().findIncidentsByProcessInstance(processInstanceId);
    }

    protected List<TaskEntity> fetchTasks(CommandContext commandContext, String processInstanceId) {
        return commandContext.getTaskManager().findTasksByProcessInstanceId(processInstanceId);
    }

    protected List<JobDefinitionEntity> fetchJobDefinitions(CommandContext commandContext, String processDefinitionId) {
        return commandContext.getJobDefinitionManager().findByProcessDefinitionId(processDefinitionId);
    }

    protected List<VariableInstanceEntity> fetchVariables(CommandContext commandContext, String processInstanceId) {
        return commandContext.getVariableInstanceManager().findVariableInstancesByProcessInstanceId(processInstanceId);
    }
}

