/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.instance.parser;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.parser.ActivityInstanceHandler;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import io.openbpm.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.JobEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.migration.MigrationInstruction;
import io.openbpm.bpm.engine.runtime.TransitionInstance;
import java.util.ArrayList;
import java.util.List;

public class TransitionInstanceHandler
implements MigratingInstanceParseHandler<TransitionInstance> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, TransitionInstance transitionInstance) {
        if (!this.isAsyncTransitionInstance(transitionInstance)) {
            return;
        }
        MigrationInstruction applyingInstruction = parseContext.getInstructionFor(transitionInstance.getActivityId());
        ActivityImpl sourceScope = parseContext.getSourceProcessDefinition().findActivity(transitionInstance.getActivityId());
        ActivityImpl targetScope = null;
        if (applyingInstruction != null) {
            String activityId = applyingInstruction.getTargetActivityId();
            targetScope = parseContext.getTargetProcessDefinition().findActivity(activityId);
        }
        ExecutionEntity asyncExecution = Context.getCommandContext().getExecutionManager().findExecutionById(transitionInstance.getExecutionId());
        MigratingTransitionInstance migratingTransitionInstance = parseContext.getMigratingProcessInstance().addTransitionInstance(applyingInstruction, transitionInstance, sourceScope, targetScope, asyncExecution);
        MigratingActivityInstance parentInstance = parseContext.getMigratingActivityInstanceById(transitionInstance.getParentActivityInstanceId());
        migratingTransitionInstance.setParent(parentInstance);
        List<JobEntity> jobs = asyncExecution.getJobs();
        parseContext.handleDependentTransitionInstanceJobs(migratingTransitionInstance, jobs);
        parseContext.handleDependentVariables(migratingTransitionInstance, this.collectTransitionInstanceVariables(migratingTransitionInstance));
    }

    protected boolean isAsyncTransitionInstance(TransitionInstance transitionInstance) {
        String executionId = transitionInstance.getExecutionId();
        ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(executionId);
        for (JobEntity job : execution.getJobs()) {
            if (!"async-continuation".equals(job.getJobHandlerType())) continue;
            return true;
        }
        return false;
    }

    protected List<VariableInstanceEntity> collectTransitionInstanceVariables(MigratingTransitionInstance instance) {
        ArrayList<VariableInstanceEntity> variables = new ArrayList<VariableInstanceEntity>();
        ExecutionEntity representativeExecution = instance.resolveRepresentativeExecution();
        if (representativeExecution.isConcurrent()) {
            variables.addAll(representativeExecution.getVariablesInternal());
        } else {
            variables.addAll(ActivityInstanceHandler.getConcurrentLocalVariables(representativeExecution));
        }
        return variables;
    }
}

