/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instance;

import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingCompensationEventSubscriptionInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingCompensationInstanceValidator;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingTransitionInstanceValidator;

public class NoUnmappedLeafInstanceValidator
implements MigratingActivityInstanceValidator,
MigratingTransitionInstanceValidator,
MigratingCompensationInstanceValidator {
    @Override
    public void validate(MigratingActivityInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl instanceReport) {
        if (this.isInvalid(migratingInstance)) {
            instanceReport.addFailure("There is no migration instruction for this instance's activity");
        }
    }

    @Override
    public void validate(MigratingTransitionInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingTransitionInstanceValidationReportImpl instanceReport) {
        if (this.isInvalid(migratingInstance)) {
            instanceReport.addFailure("There is no migration instruction for this instance's activity");
        }
    }

    @Override
    public void validate(MigratingCompensationEventSubscriptionInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl ancestorInstanceReport) {
        if (this.isInvalid(migratingInstance)) {
            ancestorInstanceReport.addFailure("Cannot migrate subscription for compensation handler '" + migratingInstance.getSourceScope().getId() + "'. There is no migration instruction for the compensation boundary event");
        }
    }

    @Override
    public void validate(MigratingEventScopeInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl ancestorInstanceReport) {
        if (this.isInvalid(migratingInstance)) {
            ancestorInstanceReport.addFailure("Cannot migrate subscription for compensation handler '" + migratingInstance.getEventSubscription().getSourceScope().getId() + "'. There is no migration instruction for the compensation start event");
        }
    }

    protected boolean isInvalid(MigratingActivityInstance migratingInstance) {
        return this.hasNoInstruction(migratingInstance) && migratingInstance.getChildren().isEmpty();
    }

    protected boolean isInvalid(MigratingEventScopeInstance migratingInstance) {
        return this.hasNoInstruction(migratingInstance.getEventSubscription()) && migratingInstance.getChildren().isEmpty();
    }

    protected boolean isInvalid(MigratingTransitionInstance migratingInstance) {
        return this.hasNoInstruction(migratingInstance);
    }

    protected boolean isInvalid(MigratingCompensationEventSubscriptionInstance migratingInstance) {
        return this.hasNoInstruction(migratingInstance);
    }

    protected boolean hasNoInstruction(MigratingProcessElementInstance migratingInstance) {
        return migratingInstance.getMigrationInstruction() == null;
    }
}

