/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instance;

import io.openbpm.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import io.openbpm.bpm.engine.impl.migration.instance.MigratingVariableInstance;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instance.MigratingActivityInstanceValidator;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariableConflictActivityInstanceValidator
implements MigratingActivityInstanceValidator {
    @Override
    public void validate(MigratingActivityInstance migratingInstance, MigratingProcessInstance migratingProcessInstance, MigratingActivityInstanceValidationReportImpl instanceReport) {
        ScopeImpl sourceScope = migratingInstance.getSourceScope();
        ScopeImpl targetScope = migratingInstance.getTargetScope();
        if (migratingInstance.migrates()) {
            boolean becomesNonScope;
            boolean bl = becomesNonScope = sourceScope.isScope() && !targetScope.isScope();
            if (becomesNonScope) {
                Map<String, List<MigratingVariableInstance>> dependentVariablesByName = this.getMigratingVariableInstancesByName(migratingInstance);
                for (Map.Entry<String, List<MigratingVariableInstance>> entry : dependentVariablesByName.entrySet()) {
                    String variableName = entry.getKey();
                    if (entry.getValue().size() <= 1) continue;
                    instanceReport.addFailure("The variable '" + variableName + "' exists in both, this scope and concurrent local in the parent scope. Migrating to a non-scope activity would overwrite one of them.");
                }
            }
        }
    }

    protected Map<String, List<MigratingVariableInstance>> getMigratingVariableInstancesByName(MigratingActivityInstance activityInstance) {
        HashMap<String, List<MigratingVariableInstance>> result = new HashMap<String, List<MigratingVariableInstance>>();
        for (MigratingInstance migratingInstance : activityInstance.getMigratingDependentInstances()) {
            if (!(migratingInstance instanceof MigratingVariableInstance)) continue;
            MigratingVariableInstance migratingVariableInstance = (MigratingVariableInstance)migratingInstance;
            CollectionUtil.addToMapOfLists(result, (Object)migratingVariableInstance.getVariableName(), (Object)migratingVariableInstance);
        }
        return result;
    }
}

