/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.migration.validation.instruction;

import io.openbpm.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.CaseCallActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import io.openbpm.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import io.openbpm.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.commons.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SameBehaviorInstructionValidator
implements MigrationInstructionValidator {
    public static final List<Set<Class<?>>> EQUIVALENT_BEHAVIORS = new ArrayList();
    protected Map<Class<?>, Set<Class<?>>> equivalentBehaviors = new HashMap();

    public SameBehaviorInstructionValidator() {
        this(EQUIVALENT_BEHAVIORS);
    }

    public SameBehaviorInstructionValidator(List<Set<Class<?>>> equivalentBehaviors) {
        for (Set<Class<?>> equivalenceClass : equivalentBehaviors) {
            for (Class<?> clazz : equivalenceClass) {
                this.equivalentBehaviors.put(clazz, equivalenceClass);
            }
        }
    }

    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        Class<?> targetBehaviorClass;
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        ActivityImpl targetActivity = instruction.getTargetActivity();
        Class<?> sourceBehaviorClass = sourceActivity.getActivityBehavior().getClass();
        if (!this.sameBehavior(sourceBehaviorClass, targetBehaviorClass = targetActivity.getActivityBehavior().getClass())) {
            report.addFailure("Activities have incompatible types (" + sourceBehaviorClass.getSimpleName() + " is not compatible with " + targetBehaviorClass.getSimpleName() + ")");
        }
    }

    protected boolean sameBehavior(Class<?> sourceBehavior, Class<?> targetBehavior) {
        if (sourceBehavior == targetBehavior) {
            return true;
        }
        Set<Class<?>> behaviors = this.equivalentBehaviors.get(sourceBehavior);
        if (behaviors != null) {
            return behaviors.contains(targetBehavior);
        }
        return false;
    }

    static {
        EQUIVALENT_BEHAVIORS.add(CollectionUtil.asHashSet((Object[])new Class[]{CallActivityBehavior.class, CaseCallActivityBehavior.class}));
        EQUIVALENT_BEHAVIORS.add(CollectionUtil.asHashSet((Object[])new Class[]{SubProcessActivityBehavior.class, EventSubProcessActivityBehavior.class}));
    }
}

