/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.deploy.cache;

import io.openbpm.bpm.engine.impl.ProcessDefinitionQueryImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.ModelInstanceCache;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.repository.ProcessDefinition;
import io.openbpm.bpm.model.bpmn.Bpmn;
import io.openbpm.bpm.model.bpmn.BpmnModelInstance;
import java.io.InputStream;
import java.util.List;

public class BpmnModelInstanceCache
extends ModelInstanceCache<BpmnModelInstance, ProcessDefinitionEntity> {
    public BpmnModelInstanceCache(CacheFactory factory, int cacheCapacity, ResourceDefinitionCache<ProcessDefinitionEntity> definitionCache) {
        super(factory, cacheCapacity, definitionCache);
    }

    @Override
    protected void throwLoadModelException(String definitionId, Exception e) {
        throw LOG.loadModelException("BPMN", "process", definitionId, e);
    }

    @Override
    protected BpmnModelInstance readModelFromStream(InputStream bpmnResourceInputStream) {
        return Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
    }

    @Override
    protected void logRemoveEntryFromDeploymentCacheFailure(String definitionId, Exception e) {
        LOG.removeEntryFromDeploymentCacheFailure("process", definitionId, e);
    }

    @Override
    protected List<ProcessDefinition> getAllDefinitionsForDeployment(String deploymentId) {
        CommandContext commandContext = Context.getCommandContext();
        return commandContext.runWithoutAuthorization(() -> new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list());
    }
}

