/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.deploy.cache;

import io.openbpm.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import io.openbpm.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.AbstractResourceDefinitionManager;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheDeployer;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.CacheFactory;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.ResourceDefinitionCache;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public class DecisionDefinitionCache
extends ResourceDefinitionCache<DecisionDefinitionEntity> {
    private static final String VAR_DECISION_DEFINITION = "decisionDefinition";
    private static final String VAR_CACHED_CASE_DEFINITION = "cachedCaseDefinition";

    public DecisionDefinitionCache(CacheFactory factory, int cacheCapacity, CacheDeployer cacheDeployer) {
        super(factory, cacheCapacity, cacheDeployer);
    }

    public DecisionDefinitionEntity findDeployedDefinitionByKeyAndVersion(String definitionKey, Integer definitionVersion) {
        DecisionDefinitionEntity definition = ((DecisionDefinitionManager)this.getManager()).findDecisionDefinitionByKeyAndVersion(definitionKey, definitionVersion);
        this.checkInvalidDefinitionByKeyAndVersion(definitionKey, definitionVersion, definition);
        return this.resolveDefinition(definition);
    }

    @Override
    protected AbstractResourceDefinitionManager<DecisionDefinitionEntity> getManager() {
        return Context.getCommandContext().getDecisionDefinitionManager();
    }

    @Override
    protected void checkInvalidDefinitionId(String definitionId) {
        EnsureUtil.ensureNotNull("Invalid decision definition id", "decisionDefinitionId", (Object)definitionId);
    }

    @Override
    protected void checkDefinitionFound(String definitionId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no deployed decision definition found with id '" + definitionId + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKey(String definitionKey, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + definitionKey + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyAndTenantId(String definitionKey, String tenantId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + definitionKey + "' and tenant-id '" + tenantId + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    protected void checkInvalidDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion, DecisionDefinitionEntity decisionDefinition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' and version = '" + decisionDefinitionVersion + "'", VAR_DECISION_DEFINITION, (Object)decisionDefinition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionAndTenantId(String definitionKey, Integer definitionVersion, String tenantId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + definitionKey + "', version = '" + definitionVersion + "' and tenant-id '" + tenantId + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByKeyVersionTagAndTenantId(String definitionKey, String definitionVersionTag, String tenantId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + definitionKey + "', versionTag = '" + definitionVersionTag + "' and tenant-id '" + tenantId + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionByDeploymentAndKey(String deploymentId, String definitionKey, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + definitionKey + "' in deployment = '" + deploymentId + "'", VAR_DECISION_DEFINITION, (Object)definition);
    }

    @Override
    protected void checkInvalidDefinitionWasCached(String deploymentId, String definitionId, DecisionDefinitionEntity definition) {
        EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put decision definition '" + definitionId + "' in the cache", VAR_CACHED_CASE_DEFINITION, (Object)definition);
    }
}

