/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.ExecutionQueryImpl;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.ProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import io.openbpm.bpm.engine.impl.db.EnginePersistenceLogger;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.SuspensionState;
import io.openbpm.bpm.engine.impl.util.ImmutablePair;
import io.openbpm.bpm.engine.runtime.Execution;
import io.openbpm.bpm.engine.runtime.ProcessInstance;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExecutionManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    private static final String PARENT_EXECUTION_ID = "parentExecutionId";

    public void insertExecution(ExecutionEntity execution) {
        this.getDbEntityManager().insert(execution);
        this.createDefaultAuthorizations(execution);
    }

    public void deleteExecution(ExecutionEntity execution) {
        this.getDbEntityManager().delete(execution);
        if (execution.isProcessInstanceExecution()) {
            this.deleteAuthorizations(Resources.PROCESS_INSTANCE, execution.getProcessInstanceId());
        }
    }

    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        List processInstanceIds = this.getDbEntityManager().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade, skipCustomListeners, false, skipIoMappings, false);
        }
        if (cascade) {
            this.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason) {
        this.deleteProcessInstance(processInstanceId, deleteReason, false, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade, boolean skipCustomListeners) {
        this.deleteProcessInstance(processInstanceId, deleteReason, cascade, skipCustomListeners, false, false, false);
    }

    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade, boolean skipCustomListeners, boolean externallyTerminated, boolean skipIoMappings, boolean skipSubprocesses) {
        ExecutionEntity execution = this.findExecutionById(processInstanceId);
        if (execution == null) {
            throw LOG.requestedProcessInstanceNotFoundException(processInstanceId);
        }
        this.getTaskManager().deleteTasksByProcessInstanceId(processInstanceId, deleteReason, cascade, skipCustomListeners);
        execution.deleteCascade(deleteReason, skipCustomListeners, skipIoMappings, externallyTerminated, skipSubprocesses);
        if (cascade) {
            this.getHistoricProcessInstanceManager().deleteHistoricProcessInstanceByIds(Arrays.asList(processInstanceId));
        }
    }

    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(String superExecutionId) {
        return (ExecutionEntity)this.getDbEntityManager().selectOne("selectSubProcessInstanceBySuperExecutionId", superExecutionId);
    }

    public ExecutionEntity findSubProcessInstanceBySuperCaseExecutionId(String superCaseExecutionId) {
        return (ExecutionEntity)this.getDbEntityManager().selectOne("selectSubProcessInstanceBySuperCaseExecutionId", superCaseExecutionId);
    }

    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(String parentExecutionId) {
        return this.getDbEntityManager().selectList("selectExecutionsByParentExecutionId", parentExecutionId);
    }

    public List<ExecutionEntity> findExecutionsByProcessInstanceId(String processInstanceId) {
        return this.getDbEntityManager().selectList("selectExecutionsByProcessInstanceId", processInstanceId);
    }

    public ExecutionEntity findExecutionById(String executionId) {
        return this.getDbEntityManager().selectById(ExecutionEntity.class, executionId);
    }

    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        this.configureQuery(executionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        this.configureQuery(executionQuery);
        return this.getDbEntityManager().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery) {
        this.configureQuery(processInstanceQuery);
        return (Long)this.getDbEntityManager().selectOne("selectProcessInstanceCountByQueryCriteria", processInstanceQuery);
    }

    public List<ProcessInstance> findProcessInstancesByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery, Page page) {
        this.configureQuery(processInstanceQuery);
        return this.getDbEntityManager().selectList("selectProcessInstanceByQueryCriteria", processInstanceQuery, page);
    }

    public List<String> findProcessInstancesIdsByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery) {
        this.configureQuery(processInstanceQuery);
        return this.getDbEntityManager().selectList("selectProcessInstanceIdsByQueryCriteria", processInstanceQuery);
    }

    public List<ImmutablePair<String, String>> findDeploymentIdMappingsByQueryCriteria(ProcessInstanceQueryImpl processInstanceQuery) {
        this.configureQuery(processInstanceQuery);
        return this.getDbEntityManager().selectList("selectProcessInstanceDeploymentIdMappingsByQueryCriteria", processInstanceQuery);
    }

    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put(PARENT_EXECUTION_ID, parentExecutionId);
        return this.getDbEntityManager().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    public void updateExecutionSuspensionStateByProcessDefinitionId(String processDefinitionId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateExecutionSuspensionStateByProcessInstanceId(String processInstanceId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateExecutionSuspensionStateByProcessDefinitionKey(String processDefinitionKey, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isTenantIdSet", false);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    public void updateExecutionSuspensionStateByProcessDefinitionKeyAndTenantId(String processDefinitionKey, String tenantId, SuspensionState suspensionState) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processDefinitionKey", processDefinitionKey);
        parameters.put("isTenantIdSet", true);
        parameters.put("tenantId", tenantId);
        parameters.put("suspensionState", suspensionState.getStateCode());
        this.getDbEntityManager().update(ExecutionEntity.class, "updateExecutionSuspensionStateByParameters", this.configureParameterizedQuery(parameters));
    }

    protected void createDefaultAuthorizations(ExecutionEntity execution) {
        if (execution.isProcessInstanceExecution() && this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newProcessInstance(execution);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureQuery(AbstractQuery<?, ?> query) {
        this.getAuthorizationManager().configureExecutionQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected ListQueryParameterObject configureParameterizedQuery(Object parameter) {
        return this.getTenantManager().configureQuery(parameter);
    }
}

