/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.history.HistoricIdentityLinkLog;
import io.openbpm.bpm.engine.impl.HistoricIdentityLinkLogQueryImpl;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoricIdentityLinkLogEventEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.persistence.AbstractHistoricManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricIdentityLinkLogEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class HistoricIdentityLinkLogManager
extends AbstractHistoricManager {
    public long findHistoricIdentityLinkLogCountByQueryCriteria(HistoricIdentityLinkLogQueryImpl query) {
        this.configureQuery(query);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricIdentityLinkCountByQueryCriteria", query);
    }

    public List<HistoricIdentityLinkLog> findHistoricIdentityLinkLogByQueryCriteria(HistoricIdentityLinkLogQueryImpl query, Page page) {
        this.configureQuery(query);
        return this.getDbEntityManager().selectList("selectHistoricIdentityLinkByQueryCriteria", query, page);
    }

    public DbOperation addRemovalTimeToIdentityLinkLogByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricIdentityLinkLogEventEntity.class, "updateIdentityLinkLogByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToIdentityLinkLogByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricIdentityLinkLogEventEntity.class, "updateIdentityLinkLogByProcessInstanceId", parameters);
    }

    public void deleteHistoricIdentityLinksLogByProcessDefinitionId(String processDefId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIdentityLinkLogEntity.class, "deleteHistoricIdentityLinksByProcessDefinitionId", processDefId);
        }
    }

    public void deleteHistoricIdentityLinksLogByTaskId(String taskId) {
        if (this.isHistoryEventProduced()) {
            this.getDbEntityManager().delete(HistoricIdentityLinkLogEntity.class, "deleteHistoricIdentityLinksByTaskId", taskId);
        }
    }

    public void deleteHistoricIdentityLinksLogByTaskProcessInstanceIds(List<String> processInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(HistoricIdentityLinkLogEntity.class, "deleteHistoricIdentityLinksByTaskProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricIdentityLinksLogByTaskCaseInstanceIds(List<String> caseInstanceIds) {
        this.getDbEntityManager().deletePreserveOrder(HistoricIdentityLinkLogEntity.class, "deleteHistoricIdentityLinksByTaskCaseInstanceIds", caseInstanceIds);
    }

    public DbOperation deleteHistoricIdentityLinkLogByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricIdentityLinkLogEntity.class, "deleteHistoricIdentityLinkLogByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }

    protected void configureQuery(HistoricIdentityLinkLogQueryImpl query) {
        this.getAuthorizationManager().configureHistoricIdentityLinkQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    protected boolean isHistoryEventProduced() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        return historyLevel.isHistoryEventProduced(HistoryEventTypes.IDENTITY_LINK_ADD, null) || historyLevel.isHistoryEventProduced(HistoryEventTypes.IDENTITY_LINK_DELETE, null);
    }
}

