/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.history.HistoricTaskInstance;
import io.openbpm.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import io.openbpm.bpm.engine.impl.history.HistoryLevel;
import io.openbpm.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import io.openbpm.bpm.engine.impl.history.event.HistoryEvent;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventProcessor;
import io.openbpm.bpm.engine.impl.history.event.HistoryEventTypes;
import io.openbpm.bpm.engine.impl.history.producer.HistoryEventProducer;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.AbstractHistoricManager;
import io.openbpm.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.TaskEntity;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricTaskInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricTaskInstancesByProcessInstanceIds(List<String> processInstanceIds, boolean deleteVariableInstances) {
        CommandContext commandContext = Context.getCommandContext();
        if (deleteVariableInstances) {
            this.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByTaskProcessInstanceIds(processInstanceIds);
        }
        this.getHistoricDetailManager().deleteHistoricDetailsByTaskProcessInstanceIds(processInstanceIds);
        commandContext.getCommentManager().deleteCommentsByTaskProcessInstanceIds(processInstanceIds);
        this.getAttachmentManager().deleteAttachmentsByTaskProcessInstanceIds(processInstanceIds);
        this.getHistoricIdentityLinkManager().deleteHistoricIdentityLinksLogByTaskProcessInstanceIds(processInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricTaskInstanceEntity.class, "deleteHistoricTaskInstanceByProcessInstanceIds", processInstanceIds);
    }

    public void deleteHistoricTaskInstancesByCaseInstanceIds(List<String> caseInstanceIds) {
        CommandContext commandContext = Context.getCommandContext();
        this.getHistoricDetailManager().deleteHistoricDetailsByTaskCaseInstanceIds(caseInstanceIds);
        commandContext.getCommentManager().deleteCommentsByTaskCaseInstanceIds(caseInstanceIds);
        this.getAttachmentManager().deleteAttachmentsByTaskCaseInstanceIds(caseInstanceIds);
        this.getHistoricIdentityLinkManager().deleteHistoricIdentityLinksLogByTaskCaseInstanceIds(caseInstanceIds);
        this.getDbEntityManager().deletePreserveOrder(HistoricTaskInstanceEntity.class, "deleteHistoricTaskInstanceByCaseInstanceIds", caseInstanceIds);
    }

    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicTaskInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureQuery(historicTaskInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery, page);
        }
        return Collections.emptyList();
    }

    public HistoricTaskInstanceEntity findHistoricTaskInstanceById(String taskId) {
        EnsureUtil.ensureNotNull("Invalid historic task id", "taskId", (Object)taskId);
        if (this.isHistoryEnabled()) {
            return (HistoricTaskInstanceEntity)this.getDbEntityManager().selectOne("selectHistoricTaskInstance", taskId);
        }
        return null;
    }

    public void deleteHistoricTaskInstanceById(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryEnabled() && (historicTaskInstance = this.findHistoricTaskInstanceById(taskId)) != null) {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoricDetailManager().deleteHistoricDetailsByTaskId(taskId);
            commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByTaskId(taskId);
            commandContext.getCommentManager().deleteCommentsByTaskId(taskId);
            commandContext.getAttachmentManager().deleteAttachmentsByTaskId(taskId);
            commandContext.getHistoricIdentityLinkManager().deleteHistoricIdentityLinksLogByTaskId(taskId);
            this.deleteAuthorizations(Resources.HISTORIC_TASK, taskId);
            this.getDbEntityManager().delete(historicTaskInstance);
        }
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }

    public void updateHistoricTaskInstance(final TaskEntity taskEntity) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_UPDATE, taskEntity)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createTaskInstanceUpdateEvt(taskEntity);
                }
            });
        }
    }

    public DbOperation addRemovalTimeToTaskInstancesByRootProcessInstanceId(String rootProcessInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("rootProcessInstanceId", rootProcessInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricTaskInstanceEventEntity.class, "updateHistoricTaskInstancesByRootProcessInstanceId", parameters);
    }

    public DbOperation addRemovalTimeToTaskInstancesByProcessInstanceId(String processInstanceId, Date removalTime, Integer batchSize) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("removalTime", removalTime);
        parameters.put("maxResults", batchSize);
        return this.getDbEntityManager().updatePreserveOrder(HistoricTaskInstanceEventEntity.class, "updateHistoricTaskInstancesByProcessInstanceId", parameters);
    }

    public void markTaskInstanceEnded(String taskId, final String deleteReason) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        final TaskEntity taskEntity = Context.getCommandContext().getDbEntityManager().selectById(TaskEntity.class, taskId);
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_COMPLETE, taskEntity)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createTaskInstanceCompleteEvt(taskEntity, deleteReason);
                }
            });
        }
    }

    public void createHistoricTask(final TaskEntity task) {
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        HistoryLevel historyLevel = configuration.getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_CREATE, task)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createTaskInstanceCreateEvt(task);
                }
            });
        }
    }

    protected void configureQuery(HistoricTaskInstanceQueryImpl query) {
        this.getAuthorizationManager().configureHistoricTaskInstanceQuery(query);
        this.getTenantManager().configureQuery(query);
    }

    public DbOperation deleteHistoricTaskInstancesByRemovalTime(Date removalTime, int minuteFrom, int minuteTo, int batchSize) {
        HashMap<String, Comparable<Date>> parameters = new HashMap<String, Comparable<Date>>();
        parameters.put("removalTime", removalTime);
        if (minuteTo - minuteFrom + 1 < 60) {
            parameters.put("minuteFrom", Integer.valueOf(minuteFrom));
            parameters.put("minuteTo", Integer.valueOf(minuteTo));
        }
        parameters.put("batchSize", Integer.valueOf(batchSize));
        return this.getDbEntityManager().deletePreserveOrder(HistoricTaskInstanceEntity.class, "deleteHistoricTaskInstancesByRemovalTime", new ListQueryParameterObject(parameters, 0, batchSize));
    }
}

