/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ResourceEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceManager
extends AbstractManager {
    private static final String DEPLOYMENT_ID = "deploymentId";
    private static final String DEPLOYMENT_NAME = "deploymentName";
    private static final String RESOURCE_ID = "resourceId";
    private static final String RESOURCE_IDS = "resourceIds";
    private static final String RESOURCE_NAME = "resourceName";
    private static final String RESOURCE_NAMES = "resourceNames";
    private static final String RESOURCES_TO_FIND = "resourcesToFind";
    private static final String SOURCE = "source";

    public void insertResource(ResourceEntity resource) {
        this.getDbEntityManager().insert(resource);
    }

    public void deleteResourcesByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(ResourceEntity.class, "deleteResourcesByDeploymentId", deploymentId);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceName(String deploymentId, String resourceName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEPLOYMENT_ID, deploymentId);
        params.put(RESOURCE_NAME, resourceName);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceName", params);
    }

    public List<ResourceEntity> findResourceByDeploymentIdAndResourceNames(String deploymentId, String ... resourceNames) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPLOYMENT_ID, deploymentId);
        params.put(RESOURCE_NAMES, resourceNames);
        return this.getDbEntityManager().selectList("selectResourceByDeploymentIdAndResourceNames", params);
    }

    public ResourceEntity findResourceByDeploymentIdAndResourceId(String deploymentId, String resourceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEPLOYMENT_ID, deploymentId);
        params.put(RESOURCE_ID, resourceId);
        return (ResourceEntity)this.getDbEntityManager().selectOne("selectResourceByDeploymentIdAndResourceId", params);
    }

    public List<ResourceEntity> findResourceByDeploymentIdAndResourceIds(String deploymentId, String ... resourceIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPLOYMENT_ID, deploymentId);
        params.put(RESOURCE_IDS, resourceIds);
        return this.getDbEntityManager().selectList("selectResourceByDeploymentIdAndResourceIds", params);
    }

    public List<ResourceEntity> findResourcesByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectResourcesByDeploymentId", deploymentId);
    }

    public Map<String, ResourceEntity> findLatestResourcesByDeploymentName(String deploymentName, Set<String> resourcesToFind, String source, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(DEPLOYMENT_NAME, deploymentName);
        params.put(RESOURCES_TO_FIND, resourcesToFind);
        params.put(SOURCE, source);
        params.put("tenantId", tenantId);
        List resources = this.getDbEntityManager().selectList("selectLatestResourcesByDeploymentName", params);
        HashMap<String, ResourceEntity> existingResourcesByName = new HashMap<String, ResourceEntity>();
        for (ResourceEntity existingResource : resources) {
            existingResourcesByName.put(existingResource.getName(), existingResource);
        }
        return existingResourcesByName;
    }
}

