/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.persistence.entity;

import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.ListQueryParameterObject;
import io.openbpm.bpm.engine.impl.db.TenantCheck;
import io.openbpm.bpm.engine.impl.identity.Authentication;
import io.openbpm.bpm.engine.impl.persistence.AbstractManager;
import java.util.List;

public class TenantManager
extends AbstractManager {
    public ListQueryParameterObject configureQuery(ListQueryParameterObject query) {
        TenantCheck tenantCheck = query.getTenantCheck();
        this.configureTenantCheck(tenantCheck);
        return query;
    }

    public void configureTenantCheck(TenantCheck tenantCheck) {
        if (this.isTenantCheckEnabled()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            tenantCheck.setTenantCheckEnabled(true);
            tenantCheck.setAuthTenantIds(currentAuthentication.getTenantIds());
        } else {
            tenantCheck.setTenantCheckEnabled(false);
            tenantCheck.setAuthTenantIds(null);
        }
    }

    public ListQueryParameterObject configureQuery(Object parameters) {
        ListQueryParameterObject queryObject = new ListQueryParameterObject();
        queryObject.setParameter(parameters);
        return this.configureQuery(queryObject);
    }

    public boolean isAuthenticatedTenant(String tenantId) {
        if (tenantId != null && this.isTenantCheckEnabled()) {
            Authentication currentAuthentication = this.getCurrentAuthentication();
            List<String> authenticatedTenantIds = currentAuthentication.getTenantIds();
            if (authenticatedTenantIds != null) {
                return authenticatedTenantIds.contains(tenantId);
            }
            return false;
        }
        return true;
    }

    public boolean isTenantCheckEnabled() {
        return Context.getProcessEngineConfiguration().isTenantCheckEnabled() && Context.getCommandContext().isTenantCheckEnabled() && this.getCurrentAuthentication() != null && !this.getAuthorizationManager().isOperatonAdmin(this.getCurrentAuthentication());
    }
}

