/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.pvm.process;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.ExecutionListener;
import io.openbpm.bpm.engine.impl.core.model.CoreActivity;
import io.openbpm.bpm.engine.impl.pvm.PvmActivity;
import io.openbpm.bpm.engine.impl.pvm.PvmException;
import io.openbpm.bpm.engine.impl.pvm.PvmScope;
import io.openbpm.bpm.engine.impl.pvm.PvmTransition;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import io.openbpm.bpm.engine.impl.pvm.process.TransitionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ScopeImpl
extends CoreActivity
implements PvmScope {
    private static final long serialVersionUID = 1L;
    protected boolean isSubProcessScope;
    protected List<ActivityImpl> flowActivities = new ArrayList<ActivityImpl>();
    protected Map<String, ActivityImpl> namedFlowActivities = new HashMap<String, ActivityImpl>();
    protected Set<ActivityImpl> eventActivities = new HashSet<ActivityImpl>();
    protected ProcessDefinitionImpl processDefinition;
    protected final Map<String, BacklogErrorCallback> backlog = new HashMap<String, BacklogErrorCallback>();

    protected ScopeImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id);
        this.processDefinition = processDefinition;
    }

    @Override
    public ActivityImpl findActivity(String activityId) {
        return (ActivityImpl)super.findActivity(activityId);
    }

    @Override
    public TransitionImpl findTransition(String transitionId) {
        for (PvmActivity pvmActivity : this.flowActivities) {
            for (PvmTransition transition : pvmActivity.getOutgoingTransitions()) {
                if (!transitionId.equals(transition.getId())) continue;
                return (TransitionImpl)transition;
            }
        }
        for (ActivityImpl activityImpl : this.flowActivities) {
            TransitionImpl nestedTransition = activityImpl.findTransition(transitionId);
            if (nestedTransition == null) continue;
            return nestedTransition;
        }
        return null;
    }

    @Override
    public ActivityImpl findActivityAtLevelOfSubprocess(String activityId) {
        if (!this.isSubProcessScope()) {
            throw new ProcessEngineException("This is not a sub process scope.");
        }
        ActivityImpl activity = this.findActivity(activityId);
        if (activity == null || activity.getLevelOfSubprocessScope() != this) {
            return null;
        }
        return activity;
    }

    @Override
    public ActivityImpl getChildActivity(String activityId) {
        return this.namedFlowActivities.get(activityId);
    }

    public Collection<BacklogErrorCallback> getBacklogErrorCallbacks() {
        return this.backlog.values();
    }

    public boolean isBacklogEmpty() {
        return this.backlog.isEmpty();
    }

    public void addToBacklog(String activityRef, BacklogErrorCallback callback) {
        this.backlog.put(activityRef, callback);
    }

    @Override
    public ActivityImpl createActivity(String activityId) {
        ActivityImpl activity = new ActivityImpl(activityId, this.processDefinition);
        if (activityId != null) {
            if (this.processDefinition.findActivity(activityId) != null) {
                throw new PvmException("duplicate activity id '" + activityId + "'");
            }
            if (this.backlog.containsKey(activityId)) {
                this.backlog.remove(activityId);
            }
            this.namedFlowActivities.put(activityId, activity);
        }
        activity.flowScope = this;
        this.flowActivities.add(activity);
        return activity;
    }

    public boolean isAncestorFlowScopeOf(ScopeImpl other) {
        for (ScopeImpl otherAncestor = other.getFlowScope(); otherAncestor != null; otherAncestor = otherAncestor.getFlowScope()) {
            if (this != otherAncestor) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ActivityImpl activity) {
        if (this.namedFlowActivities.containsKey(activity.getId())) {
            return true;
        }
        for (ActivityImpl nestedActivity : this.flowActivities) {
            if (!nestedActivity.contains(activity)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public List<ExecutionListener> getExecutionListeners(String eventName) {
        return super.getListeners(eventName);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void addExecutionListener(String eventName, ExecutionListener executionListener) {
        super.addListener(eventName, executionListener);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void addExecutionListener(String eventName, ExecutionListener executionListener, int index) {
        super.addListener(eventName, executionListener, index);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public Map<String, List<ExecutionListener>> getExecutionListeners() {
        return super.getListeners();
    }

    public List<ActivityImpl> getActivities() {
        return this.flowActivities;
    }

    public Set<ActivityImpl> getEventActivities() {
        return this.eventActivities;
    }

    @Override
    public boolean isSubProcessScope() {
        return this.isSubProcessScope;
    }

    public void setSubProcessScope(boolean isSubProcessScope) {
        this.isSubProcessScope = isSubProcessScope;
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        return this.processDefinition;
    }

    public static interface BacklogErrorCallback {
        public void callback();
    }
}

