/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.runtime;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.bpmn.helper.BpmnProperties;
import io.openbpm.bpm.engine.impl.bpmn.parser.ConditionalEventDefinition;
import io.openbpm.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import io.openbpm.bpm.engine.impl.cmd.CommandLogger;
import io.openbpm.bpm.engine.impl.event.EventType;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.EventSubscriptionManager;
import io.openbpm.bpm.engine.impl.persistence.entity.ExecutionEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.runtime.ConditionHandler;
import io.openbpm.bpm.engine.impl.runtime.ConditionHandlerResult;
import io.openbpm.bpm.engine.impl.runtime.ConditionSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultConditionHandler
implements ConditionHandler {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    @Override
    public List<ConditionHandlerResult> evaluateStartCondition(CommandContext commandContext, ConditionSet conditionSet) {
        if (conditionSet.getProcessDefinitionId() == null) {
            return this.evaluateConditionStartByEventSubscription(commandContext, conditionSet);
        }
        return this.evaluateConditionStartByProcessDefinitionId(commandContext, conditionSet, conditionSet.getProcessDefinitionId());
    }

    protected List<ConditionHandlerResult> evaluateConditionStartByEventSubscription(CommandContext commandContext, ConditionSet conditionSet) {
        List<EventSubscriptionEntity> subscriptions = this.findConditionalStartEventSubscriptions(commandContext, conditionSet);
        if (subscriptions.isEmpty()) {
            throw LOG.exceptionWhenEvaluatingConditionalStartEvent();
        }
        ArrayList<ConditionHandlerResult> results = new ArrayList<ConditionHandlerResult>();
        for (EventSubscriptionEntity subscription : subscriptions) {
            ActivityImpl activity;
            ProcessDefinitionEntity processDefinition = subscription.getProcessDefinition();
            if (processDefinition.isSuspended() || !this.evaluateCondition(conditionSet, activity = subscription.getActivity())) continue;
            results.add(new ConditionHandlerResult(processDefinition, activity));
        }
        return results;
    }

    protected List<EventSubscriptionEntity> findConditionalStartEventSubscriptions(CommandContext commandContext, ConditionSet conditionSet) {
        EventSubscriptionManager eventSubscriptionManager = commandContext.getEventSubscriptionManager();
        if (conditionSet.isTenantIdSet) {
            return eventSubscriptionManager.findConditionalStartEventSubscriptionByTenantId(conditionSet.getTenantId());
        }
        return eventSubscriptionManager.findConditionalStartEventSubscription();
    }

    protected List<ConditionHandlerResult> evaluateConditionStartByProcessDefinitionId(CommandContext commandContext, ConditionSet conditionSet, String processDefinitionId) {
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        ArrayList<ConditionHandlerResult> results = new ArrayList<ConditionHandlerResult>();
        if (processDefinition != null && !processDefinition.isSuspended()) {
            List<ActivityImpl> activities = this.findConditionalStartEventActivities(processDefinition);
            if (activities.isEmpty()) {
                throw LOG.exceptionWhenEvaluatingConditionalStartEventByProcessDefinition(processDefinitionId);
            }
            for (ActivityImpl activity : activities) {
                if (!this.evaluateCondition(conditionSet, activity)) continue;
                results.add(new ConditionHandlerResult(processDefinition, activity));
            }
        }
        return results;
    }

    protected List<ActivityImpl> findConditionalStartEventActivities(ProcessDefinitionEntity processDefinition) {
        ArrayList<ActivityImpl> activities = new ArrayList<ActivityImpl>();
        for (EventSubscriptionDeclaration declaration : EventSubscriptionDeclaration.getDeclarationsForScope(processDefinition).values()) {
            if (!this.isConditionStartEvent(declaration)) continue;
            activities.add(((ConditionalEventDefinition)declaration).getConditionalActivity());
        }
        return activities;
    }

    protected boolean isConditionStartEvent(EventSubscriptionDeclaration declaration) {
        return EventType.CONDITONAL.name().equals(declaration.getEventType()) && declaration.isStartEvent();
    }

    protected boolean evaluateCondition(ConditionSet conditionSet, ActivityImpl activity) {
        ExecutionEntity temporaryExecution = new ExecutionEntity();
        if (conditionSet.getVariables() != null) {
            temporaryExecution.initializeVariableStore((Map<String, Object>)conditionSet.getVariables());
        }
        temporaryExecution.setProcessDefinition(activity.getProcessDefinition());
        ConditionalEventDefinition conditionalEventDefinition = activity.getProperties().get(BpmnProperties.CONDITIONAL_EVENT_DEFINITION);
        if (conditionalEventDefinition.getVariableName() == null || conditionSet.getVariables().containsKey((Object)conditionalEventDefinition.getVariableName())) {
            return conditionalEventDefinition.tryEvaluate(temporaryExecution);
        }
        return false;
    }
}

