/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting;

import io.openbpm.bpm.engine.ScriptEvaluationException;
import io.openbpm.bpm.engine.delegate.BpmnError;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import io.openbpm.bpm.engine.impl.scripting.ScriptLogger;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class CompiledExecutableScript
extends ExecutableScript {
    private static final ScriptLogger LOG = ProcessEngineLogger.SCRIPT_LOGGER;
    protected CompiledScript compiledScript;

    protected CompiledExecutableScript(String language) {
        this(language, null);
    }

    protected CompiledExecutableScript(String language, CompiledScript compiledScript) {
        super(language);
        this.compiledScript = compiledScript;
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript compiledScript) {
        this.compiledScript = compiledScript;
    }

    @Override
    public Object evaluate(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        try {
            LOG.debugEvaluatingCompiledScript(this.language);
            return this.getCompiledScript().eval(bindings);
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            if (cause instanceof BpmnError) {
                BpmnError bpmnError = (BpmnError)cause;
                throw bpmnError;
            }
            String activityIdMessage = this.getActivityIdExceptionMessage(variableScope);
            throw new ScriptEvaluationException("Unable to evaluate script" + activityIdMessage + ": " + e.getMessage(), e);
        }
    }
}

