/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting;

import io.openbpm.bpm.engine.ScriptEvaluationException;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public abstract class DynamicExecutableScript
extends ExecutableScript {
    protected final Expression scriptExpression;

    protected DynamicExecutableScript(Expression scriptExpression, String language) {
        super(language);
        this.scriptExpression = scriptExpression;
    }

    @Override
    public Object evaluate(ScriptEngine scriptEngine, VariableScope variableScope, Bindings bindings) {
        String source = this.getScriptSource(variableScope);
        try {
            return scriptEngine.eval(source, bindings);
        }
        catch (ScriptException e) {
            String activityIdMessage = this.getActivityIdExceptionMessage(variableScope);
            throw new ScriptEvaluationException("Unable to evaluate script" + activityIdMessage + ": " + e.getMessage(), e);
        }
    }

    protected String evaluateExpression(VariableScope variableScope) {
        return (String)this.scriptExpression.getValue(variableScope);
    }

    public abstract String getScriptSource(VariableScope var1);
}

