/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting;

import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.persistence.entity.DeploymentEntity;
import io.openbpm.bpm.engine.impl.scripting.SourceExecutableScript;
import io.openbpm.bpm.engine.impl.util.ResourceUtil;
import javax.script.Bindings;
import javax.script.ScriptEngine;

public class ResourceExecutableScript
extends SourceExecutableScript {
    protected String scriptResource;

    public ResourceExecutableScript(String language, String scriptResource) {
        super(language, (String)null);
        this.scriptResource = scriptResource;
    }

    @Override
    public Object evaluate(ScriptEngine engine, VariableScope variableScope, Bindings bindings) {
        if (this.scriptSource == null) {
            this.loadScriptSource();
        }
        return super.evaluate(engine, variableScope, bindings);
    }

    protected synchronized void loadScriptSource() {
        if (this.getScriptSource() == null) {
            DeploymentEntity deployment = Context.getCoreExecutionContext().getDeployment();
            String source = ResourceUtil.loadResourceContent(this.scriptResource, deployment);
            this.setScriptSource(source);
        }
    }
}

