/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.scripting.engine;

import io.openbpm.bpm.engine.delegate.VariableScope;
import io.openbpm.bpm.engine.impl.scripting.engine.Resolver;
import io.openbpm.bpm.engine.impl.scripting.engine.ResolverFactory;
import io.openbpm.bpm.engine.impl.scripting.engine.ScriptBindings;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;

public class ScriptBindingsFactory {
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(VariableScope variableScope, Bindings engineBindings) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(variableScope);
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return new ScriptBindings(scriptResolvers, variableScope, engineBindings);
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

