/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.tree;

import io.openbpm.bpm.engine.impl.pvm.PvmScope;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.bpm.engine.impl.pvm.process.ScopeImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.tree.TreeVisitor;
import java.util.HashMap;
import java.util.Map;

public class ActivityExecutionMappingCollector
implements TreeVisitor<ActivityExecution> {
    private final Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = new HashMap<ScopeImpl, PvmExecutionImpl>();
    private final ActivityExecution initialExecution;
    private boolean initialized;

    public ActivityExecutionMappingCollector(ActivityExecution execution) {
        this.initialExecution = execution;
    }

    @Override
    public void visit(ActivityExecution execution) {
        if (!this.initialized) {
            this.appendActivityExecutionMapping(this.initialExecution);
            this.initialized = true;
        }
        this.appendActivityExecutionMapping(execution);
    }

    private void appendActivityExecutionMapping(ActivityExecution execution) {
        if (execution.getActivity() != null && !LegacyBehavior.hasInvalidIntermediaryActivityId((PvmExecutionImpl)execution)) {
            this.activityExecutionMapping.putAll(execution.createActivityExecutionMapping());
        }
    }

    public PvmExecutionImpl getExecutionForScope(PvmScope scope) {
        return this.activityExecutionMapping.get(scope);
    }
}

