/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import io.openbpm.bpm.engine.impl.cmmn.execution.CmmnExecution;
import io.openbpm.bpm.engine.impl.cmmn.model.CmmnActivity;
import io.openbpm.bpm.engine.impl.pvm.PvmException;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import io.openbpm.bpm.engine.impl.pvm.process.ActivityImpl;
import io.openbpm.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;

public final class ActivityBehaviorUtil {
    private ActivityBehaviorUtil() {
    }

    public static CmmnActivityBehavior getActivityBehavior(CmmnExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + id + "' has no current activity.", "activity", (Object)activity);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        EnsureUtil.ensureNotNull(PvmException.class, "There is no behavior specified in " + String.valueOf(activity) + " for case execution '" + id + "'.", "behavior", (Object)behavior);
        return behavior;
    }

    public static ActivityBehavior getActivityBehavior(PvmExecutionImpl execution) {
        String id = execution.getId();
        ActivityImpl activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Execution '" + id + "' has no current activity.", "activity", (Object)activity);
        ActivityBehavior behavior = activity.getActivityBehavior();
        EnsureUtil.ensureNotNull(PvmException.class, "There is no behavior specified in " + String.valueOf(activity) + " for execution '" + id + "'.", "behavior", (Object)behavior);
        return behavior;
    }
}

