/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public final class CompareUtil {
    private CompareUtil() {
    }

    public static <T extends Comparable<T>> boolean areNotInAscendingOrder(T ... values) {
        boolean excluding = false;
        if (values != null) {
            excluding = CompareUtil.areNotInAscendingOrder(Arrays.asList(values));
        }
        return excluding;
    }

    public static <T extends Comparable<T>> boolean areNotInAscendingOrder(List<T> values) {
        int lastNotNull = -1;
        for (int i = 0; i < values.size(); ++i) {
            Comparable value = (Comparable)values.get(i);
            if (value == null) continue;
            if (lastNotNull != -1 && ((Comparable)values.get(lastNotNull)).compareTo(value) > 0) {
                return true;
            }
            lastNotNull = i;
        }
        return false;
    }

    public static <T> boolean elementIsNotContainedInList(T element, Collection<T> values) {
        if (element != null && values != null) {
            return !values.contains(element);
        }
        return false;
    }

    public static <T> boolean elementIsNotContainedInArray(T element, T ... values) {
        if (element != null && values != null) {
            return CompareUtil.elementIsNotContainedInList(element, Arrays.asList(values));
        }
        return false;
    }

    public static <T> boolean elementIsContainedInList(T element, Collection<T> values) {
        if (element != null && values != null) {
            return values.contains(element);
        }
        return false;
    }

    public static <T> boolean elementIsContainedInArray(T element, T ... values) {
        if (element != null && values != null) {
            return CompareUtil.elementIsContainedInList(element, Arrays.asList(values));
        }
        return false;
    }

    public static <T extends Comparable<T>> T min(T obj1, T obj2) {
        return obj1.compareTo(obj2) <= 0 ? obj1 : obj2;
    }

    public static <T extends Comparable<T>> T max(T obj1, T obj2) {
        return obj1.compareTo(obj2) >= 0 ? obj1 : obj2;
    }

    public static <T> boolean elementsAreContainedInArray(Collection<T> subset, T[] superset) {
        if (subset != null && !subset.isEmpty() && superset != null && superset.length > 0 && superset.length >= subset.size()) {
            return new HashSet<T>(Arrays.asList(superset)).containsAll(subset);
        }
        return false;
    }
}

