/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.dmn.engine.DmnDecisionResult;
import io.openbpm.bpm.dmn.engine.DmnDecisionTableResult;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionTableResultImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.core.model.BaseCallableElement;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.dmn.invocation.DecisionInvocation;
import io.openbpm.bpm.engine.impl.dmn.invocation.VariableScopeContext;
import io.openbpm.bpm.engine.impl.dmn.result.CollectEntriesDecisionResultMapper;
import io.openbpm.bpm.engine.impl.dmn.result.DecisionResultMapper;
import io.openbpm.bpm.engine.impl.dmn.result.ResultListDecisionTableResultMapper;
import io.openbpm.bpm.engine.impl.dmn.result.SingleEntryDecisionResultMapper;
import io.openbpm.bpm.engine.impl.dmn.result.SingleResultDecisionResultMapper;
import io.openbpm.bpm.engine.impl.util.CallableElementUtil;
import io.openbpm.bpm.engine.repository.DecisionDefinition;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.bpm.engine.variable.value.TypedValue;

public final class DecisionEvaluationUtil {
    public static final String DECISION_RESULT_VARIABLE = "decisionResult";

    private DecisionEvaluationUtil() {
    }

    public static DecisionResultMapper getDecisionResultMapperForName(String mapDecisionResult) {
        if ("singleEntry".equals(mapDecisionResult)) {
            return new SingleEntryDecisionResultMapper();
        }
        if ("singleResult".equals(mapDecisionResult)) {
            return new SingleResultDecisionResultMapper();
        }
        if ("collectEntries".equals(mapDecisionResult)) {
            return new CollectEntriesDecisionResultMapper();
        }
        if ("resultList".equals(mapDecisionResult) || mapDecisionResult == null) {
            return new ResultListDecisionTableResultMapper();
        }
        return null;
    }

    public static void evaluateDecision(AbstractVariableScope execution, String defaultTenantId, BaseCallableElement callableElement, String resultVariable, DecisionResultMapper decisionResultMapper) throws Exception {
        DecisionDefinition decisionDefinition = DecisionEvaluationUtil.resolveDecisionDefinition(callableElement, execution, defaultTenantId);
        DecisionInvocation invocation = DecisionEvaluationUtil.createInvocation(decisionDefinition, execution);
        DecisionEvaluationUtil.invoke(invocation);
        DmnDecisionResult result = invocation.getInvocationResult();
        if (result != null) {
            TypedValue typedValue = Variables.untypedValue((Object)result, (boolean)true);
            execution.setVariableLocal(DECISION_RESULT_VARIABLE, typedValue);
            if (resultVariable != null && decisionResultMapper != null) {
                Object mappedDecisionResult = decisionResultMapper.mapDecisionResult(result);
                execution.setVariable(resultVariable, mappedDecisionResult);
            }
        }
    }

    public static DmnDecisionResult evaluateDecision(DecisionDefinition decisionDefinition, VariableMap variables) throws Exception {
        DecisionInvocation invocation = DecisionEvaluationUtil.createInvocation(decisionDefinition, variables);
        DecisionEvaluationUtil.invoke(invocation);
        return invocation.getInvocationResult();
    }

    public static DmnDecisionTableResult evaluateDecisionTable(DecisionDefinition decisionDefinition, VariableMap variables) throws Exception {
        DmnDecisionResult decisionResult = DecisionEvaluationUtil.evaluateDecision(decisionDefinition, variables);
        return DmnDecisionTableResultImpl.wrap((DmnDecisionResult)decisionResult);
    }

    protected static void invoke(DecisionInvocation invocation) throws Exception {
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, VariableMap variables) {
        return DecisionEvaluationUtil.createInvocation(decisionDefinition, variables.asVariableContext());
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, AbstractVariableScope variableScope) {
        return DecisionEvaluationUtil.createInvocation(decisionDefinition, VariableScopeContext.wrap(variableScope));
    }

    protected static DecisionInvocation createInvocation(DecisionDefinition decisionDefinition, VariableContext variableContext) {
        return new DecisionInvocation(decisionDefinition, variableContext);
    }

    protected static DecisionDefinition resolveDecisionDefinition(BaseCallableElement callableElement, AbstractVariableScope execution, String defaultTenantId) {
        return CallableElementUtil.getDecisionDefinitionToCall(execution, defaultTenantId, callableElement);
    }
}

