/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.util.EngineUtilLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public final class IoUtil {
    private static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;

    private IoUtil() {
    }

    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw LOG.exceptionWhileReadingStream(inputStreamName, e);
        }
        return outputStream.toByteArray();
    }

    public static String readClasspathResourceAsString(String resourceName) {
        byte[] result;
        InputStream resourceAsStream = IoUtil.class.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new ProcessEngineException("resource " + resourceName + " not found");
        }
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             BufferedInputStream inputStream = new BufferedInputStream(resourceAsStream);){
            int next;
            while ((next = inputStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, next);
            }
            result = outStream.toByteArray();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileReadingFile(resourceName, e);
        }
        return new String(result, StandardCharsets.UTF_8);
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw LOG.exceptionWhileGettingFile(filePath, e);
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(IoUtil.getFile(filePath)));){
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileWritingToFile(filePath, e);
        }
    }

    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }

    public static void flushSilently(Flushable flushable) {
        try {
            if (flushable != null) {
                flushable.flush();
            }
        }
        catch (IOException ignore) {
            LOG.debugCloseException(ignore);
        }
    }
}

