/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.ProcessEngineConfiguration;
import io.openbpm.bpm.engine.authorization.Authorization;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import java.util.ArrayList;

public final class PermissionConverter {
    private PermissionConverter() {
    }

    public static Permission[] getPermissionsForNames(String[] names, int resourceType, ProcessEngineConfiguration engineConfiguration) {
        Permission[] permissions = new Permission[names.length];
        for (int i = 0; i < names.length; ++i) {
            permissions[i] = ((ProcessEngineConfigurationImpl)engineConfiguration).getPermissionProvider().getPermissionForName(names[i], resourceType);
        }
        return permissions;
    }

    public static String[] getNamesForPermissions(Authorization authorization, Permission[] permissions) {
        int type = authorization.getAuthorizationType();
        if ((type == 0 || type == 1) && authorization.isEveryPermissionGranted()) {
            return new String[]{Permissions.ALL.getName()};
        }
        if (type == 2 && authorization.isEveryPermissionRevoked()) {
            return new String[]{Permissions.ALL.getName()};
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Permission permission : permissions) {
            String name = permission.getName();
            if (name.equals(Permissions.NONE.getName()) || name.equals(Permissions.ALL.getName())) continue;
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }
}

