/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.BatchPermissions;
import io.openbpm.bpm.engine.authorization.HistoricProcessInstancePermissions;
import io.openbpm.bpm.engine.authorization.HistoricTaskPermissions;
import io.openbpm.bpm.engine.authorization.OptimizePermissions;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.ProcessDefinitionPermissions;
import io.openbpm.bpm.engine.authorization.ProcessInstancePermissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.authorization.SystemPermissions;
import io.openbpm.bpm.engine.authorization.TaskPermissions;
import io.openbpm.bpm.engine.authorization.UserOperationLogCategoryPermissions;
import java.util.HashMap;
import java.util.Map;

public final class ResourceTypeUtil {
    protected static final Map<Integer, Class<? extends Enum<? extends Permission>>> PERMISSION_ENUMS = new HashMap<Integer, Class<SystemPermissions>>(Map.of(Resources.BATCH.resourceType(), BatchPermissions.class, Resources.PROCESS_DEFINITION.resourceType(), ProcessDefinitionPermissions.class, Resources.PROCESS_INSTANCE.resourceType(), ProcessInstancePermissions.class, Resources.TASK.resourceType(), TaskPermissions.class, Resources.HISTORIC_TASK.resourceType(), HistoricTaskPermissions.class, Resources.HISTORIC_PROCESS_INSTANCE.resourceType(), HistoricProcessInstancePermissions.class, Resources.OPERATION_LOG_CATEGORY.resourceType(), UserOperationLogCategoryPermissions.class, Resources.OPTIMIZE.resourceType(), OptimizePermissions.class, Resources.SYSTEM.resourceType(), SystemPermissions.class));

    private ResourceTypeUtil() {
    }

    public static boolean resourceIsContainedInArray(Integer resourceTypeId, Resource[] resources) {
        for (Resource resource : resources) {
            if (resourceTypeId.intValue() != resource.resourceType()) continue;
            return true;
        }
        return false;
    }

    public static Map<Integer, Class<? extends Enum<? extends Permission>>> getPermissionEnums() {
        return PERMISSION_ENUMS;
    }

    public static Permission[] getPermissionsByResourceType(int givenResourceType) {
        Class<? extends Enum<? extends Permission>> clazz = PERMISSION_ENUMS.get(givenResourceType);
        if (clazz == null) {
            return Permissions.values();
        }
        return (Permission[])clazz.getEnumConstants();
    }

    public static Permission getPermissionByNameAndResourceType(String permissionName, int resourceType) {
        for (Permission permission : ResourceTypeUtil.getPermissionsByResourceType(resourceType)) {
            if (!permission.getName().equals(permissionName)) continue;
            return permission;
        }
        throw new BadUserRequestException("The permission '%s' is not valid for '%s' resource type.".formatted(permissionName, ResourceTypeUtil.getResourceByType(resourceType)));
    }

    public static Resource getResourceByType(int resourceType) {
        for (Resources resource : Resources.values()) {
            if (resource.resourceType() != resourceType) continue;
            return resource;
        }
        return null;
    }

    static {
        for (Permissions permission : Permissions.values()) {
            if (permission.equals(Permissions.ALL) || permission.equals(Permissions.NONE)) continue;
            for (Resource resource : permission.getTypes()) {
                int resourceType = resource.resourceType();
                if (PERMISSION_ENUMS.containsKey(resourceType)) continue;
                PERMISSION_ENUMS.put(resourceType, Permissions.class);
            }
        }
    }
}

