/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util;

import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.el.ExpressionManager;
import io.openbpm.bpm.engine.impl.scripting.ExecutableScript;
import io.openbpm.bpm.engine.impl.scripting.ScriptFactory;
import io.openbpm.bpm.engine.impl.scripting.engine.JuelScriptEngineFactory;
import io.openbpm.bpm.engine.impl.util.EnsureUtil;
import io.openbpm.bpm.engine.impl.util.StringUtil;

public final class ScriptUtil {
    private ScriptUtil() {
    }

    public static ExecutableScript getScript(String language, String source, String resource, ExpressionManager expressionManager) {
        return ScriptUtil.getScript(language, source, resource, expressionManager, ScriptUtil.getScriptFactory());
    }

    public static ExecutableScript getScript(String language, String source, String resource, ExpressionManager expressionManager, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureAtLeastOneNotNull(NotValidException.class, "No script source or resource was given", source, resource);
        if (resource != null && !resource.isEmpty()) {
            return ScriptUtil.getScriptFromResource(language, resource, expressionManager, scriptFactory);
        }
        return ScriptUtil.getScriptFormSource(language, source, expressionManager, scriptFactory);
    }

    public static ExecutableScript getScriptFormSource(String language, String source, ExpressionManager expressionManager, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotNull(NotValidException.class, "Script source", (Object)source);
        if (ScriptUtil.isDynamicScriptExpression(language, source)) {
            io.openbpm.bpm.engine.impl.el.Expression sourceExpression = expressionManager.createExpression(source);
            return ScriptUtil.getScriptFromSourceExpression(language, sourceExpression, scriptFactory);
        }
        return ScriptUtil.getScriptFromSource(language, source, scriptFactory);
    }

    public static ExecutableScript getScriptFromSource(String language, String source, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotNull(NotValidException.class, "Script source", (Object)source);
        return scriptFactory.createScriptFromSource(language, source);
    }

    public static ExecutableScript getScriptFromSourceExpression(String language, Expression sourceExpression, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotNull(NotValidException.class, "Script source expression", (Object)sourceExpression);
        return scriptFactory.createScriptFromSource(language, sourceExpression);
    }

    public static ExecutableScript getScriptFromResource(String language, String resource, ExpressionManager expressionManager, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotEmpty(NotValidException.class, "Script resource", resource);
        if (ScriptUtil.isDynamicScriptExpression(language, resource)) {
            io.openbpm.bpm.engine.impl.el.Expression resourceExpression = expressionManager.createExpression(resource);
            return ScriptUtil.getScriptFromResourceExpression(language, resourceExpression, scriptFactory);
        }
        return ScriptUtil.getScriptFromResource(language, resource, scriptFactory);
    }

    public static ExecutableScript getScriptFromResource(String language, String resource, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotEmpty(NotValidException.class, "Script resource", resource);
        return scriptFactory.createScriptFromResource(language, resource);
    }

    public static ExecutableScript getScriptFromResourceExpression(String language, Expression resourceExpression, ScriptFactory scriptFactory) {
        ScriptUtil.ensureScriptLanguageNotEmpty(language);
        EnsureUtil.ensureNotNull(NotValidException.class, "Script resource expression", (Object)resourceExpression);
        return scriptFactory.createScriptFromResource(language, resourceExpression);
    }

    public static boolean isDynamicScriptExpression(String language, String value) {
        return StringUtil.isExpression(value) && language != null && !JuelScriptEngineFactory.names.contains(language.toLowerCase());
    }

    public static ScriptFactory getScriptFactory() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        if (processEngineConfiguration != null) {
            return processEngineConfiguration.getScriptFactory();
        }
        return new ScriptFactory();
    }

    private static void ensureScriptLanguageNotEmpty(String language) {
        EnsureUtil.ensureNotEmpty(NotValidException.class, "Script language", language);
    }
}

