/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.util.xml;

import io.openbpm.bpm.engine.impl.ProcessEngineLogger;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.util.EngineUtilLogger;
import io.openbpm.bpm.engine.impl.util.xml.Parse;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

public abstract class Parser {
    protected static final EngineUtilLogger LOG = ProcessEngineLogger.UTIL_LOGGER;
    protected static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    protected static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    protected static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final ThreadLocal<SAXParserFactory> SAX_PARSER_FACTORY_INSTANCE = ThreadLocal.withInitial(SAXParserFactory::newInstance);

    public abstract Parse createParse();

    protected SAXParser getSaxParser() throws Exception {
        SAXParserFactory saxParserFactory = this.getSaxParserFactoryLazily();
        this.setXxeProcessing(saxParserFactory);
        return saxParserFactory.newSAXParser();
    }

    protected SAXParserFactory getSaxParserFactoryLazily() {
        return SAX_PARSER_FACTORY_INSTANCE.get();
    }

    protected void enableSchemaValidation(boolean enableSchemaValidation) {
        SAXParserFactory saxParserFactory = this.getSaxParserFactoryLazily();
        saxParserFactory.setNamespaceAware(enableSchemaValidation);
        saxParserFactory.setValidating(enableSchemaValidation);
        try {
            saxParserFactory.setFeature(NAMESPACE_PREFIXES, true);
        }
        catch (Exception e) {
            LOG.unableToSetSchemaResource(e);
        }
    }

    protected void setXxeProcessing(SAXParserFactory saxParserFactory) {
        boolean enableXxeProcessing = this.isEnableXxeProcessing();
        saxParserFactory.setXIncludeAware(enableXxeProcessing);
        try {
            saxParserFactory.setFeature(EXTERNAL_GENERAL_ENTITIES, enableXxeProcessing);
            saxParserFactory.setFeature(DISALLOW_DOCTYPE_DECL, !enableXxeProcessing);
            saxParserFactory.setFeature(LOAD_EXTERNAL_DTD, enableXxeProcessing);
            saxParserFactory.setFeature(EXTERNAL_PARAMETER_ENTITIES, enableXxeProcessing);
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e) {
            throw LOG.exceptionWhileSettingXxeProcessing(e);
        }
    }

    public Boolean isEnableXxeProcessing() {
        ProcessEngineConfigurationImpl engineConfig = Context.getProcessEngineConfiguration();
        if (engineConfig != null) {
            return engineConfig.isEnableXxeProcessing();
        }
        return false;
    }
}

