/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.variable.listener;

import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.delegate.CaseVariableListener;
import io.openbpm.bpm.engine.delegate.DelegateCaseVariableInstance;
import io.openbpm.bpm.engine.delegate.Expression;
import io.openbpm.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.util.ClassDelegateUtil;
import io.openbpm.bpm.engine.impl.variable.listener.CaseVariableListenerInvocation;
import java.util.List;

public class DelegateExpressionCaseVariableListener
implements CaseVariableListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionCaseVariableListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateCaseVariableInstance variableInstance) throws Exception {
        Object delegate = this.expression.getValue(variableInstance.getSourceExecution());
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (!(delegate instanceof CaseVariableListener)) {
            throw new ProcessEngineException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(CaseVariableListener.class));
        }
        CaseVariableListener listenerInstance = (CaseVariableListener)delegate;
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new CaseVariableListenerInvocation(listenerInstance, variableInstance));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

