/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.impl.variable.serializer;

import io.openbpm.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import io.openbpm.bpm.engine.impl.variable.serializer.ValueFields;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.impl.value.UntypedValueImpl;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.BooleanValue;

public class BooleanValueSerializer
extends PrimitiveValueSerializer<BooleanValue> {
    private static final Long TRUE = 1L;
    private static final Long FALSE = 0L;

    public BooleanValueSerializer() {
        super(ValueType.BOOLEAN);
    }

    @Override
    public BooleanValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.booleanValue((Boolean)((Boolean)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public BooleanValue readValue(ValueFields valueFields, boolean asTransientValue) {
        Boolean boolValue = null;
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            boolValue = longValue.equals(TRUE);
        }
        return Variables.booleanValue(boolValue, (boolean)asTransientValue);
    }

    @Override
    public void writeValue(BooleanValue variableValue, ValueFields valueFields) {
        Long longValue = null;
        Boolean boolValue = (Boolean)variableValue.getValue();
        if (boolValue != null) {
            longValue = Boolean.TRUE.equals(boolValue) ? TRUE : FALSE;
        }
        valueFields.setLongValue(longValue);
    }
}

