/*
 * Decompiled with CFR 0.152.
 */
package openbpmjar.impl.com.cronutils.validation;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import openbpmjar.impl.com.cronutils.model.CronType;
import openbpmjar.impl.com.cronutils.model.definition.CronDefinition;
import openbpmjar.impl.com.cronutils.model.definition.CronDefinitionBuilder;
import openbpmjar.impl.com.cronutils.parser.CronParser;
import openbpmjar.impl.com.cronutils.validation.Cron;

public class CronValidator
implements ConstraintValidator<Cron, String> {
    private CronType type;

    public void initialize(Cron constraintAnnotation) {
        this.type = constraintAnnotation.type();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor(this.type);
        CronParser cronParser = new CronParser(cronDefinition);
        try {
            cronParser.parse(value).validate();
            return true;
        }
        catch (IllegalArgumentException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(e.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

