/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect;

import io.openbpm.connect.impl.ConnectCoreLogger;
import io.openbpm.connect.impl.ConnectLogger;
import io.openbpm.connect.spi.Connector;
import io.openbpm.connect.spi.ConnectorConfigurator;
import io.openbpm.connect.spi.ConnectorProvider;
import io.openbpm.connect.spi.ConnectorRequest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class Connectors {
    protected static final ConnectCoreLogger LOG = ConnectLogger.CORE_LOGGER;
    public static final String HTTP_CONNECTOR_ID = "http-connector";
    public static final String SOAP_HTTP_CONNECTOR_ID = "soap-http-connector";
    static Connectors INSTANCE = new Connectors();
    protected Map<String, Connector<?>> availableConnectors;

    public static Connectors getInstance() {
        return INSTANCE;
    }

    public static <C extends Connector<? extends ConnectorRequest<?>>> C http() {
        return INSTANCE.getConnectorById(HTTP_CONNECTOR_ID);
    }

    public static <C extends Connector<? extends ConnectorRequest<?>>> C soap() {
        return INSTANCE.getConnectorById(SOAP_HTTP_CONNECTOR_ID);
    }

    public static <C extends Connector<? extends ConnectorRequest<?>>> C getConnector(String connectorId) {
        return INSTANCE.getConnectorById(connectorId);
    }

    public static Set<Connector<? extends ConnectorRequest<?>>> getAvailableConnectors() {
        return INSTANCE.getAllAvailableConnectors();
    }

    public static void loadConnectors() {
        Connectors.loadConnectors(null);
    }

    public static void loadConnectors(ClassLoader classloader) {
        INSTANCE.initializeConnectors(classloader);
    }

    protected static void registerConnector(Connector<?> connector) {
        Connectors.registerConnector(connector.getId(), connector);
    }

    protected static void registerConnector(String connectorId, Connector<?> connector) {
        INSTANCE.registerConnectorInstance(connectorId, connector);
    }

    protected static void unregisterConnector(String connectorId) {
        INSTANCE.unregisterConnectorInstance(connectorId);
    }

    public Set<Connector<? extends ConnectorRequest<?>>> getAllAvailableConnectors() {
        this.ensureConnectorProvidersInitialized();
        return new HashSet(this.availableConnectors.values());
    }

    public <C extends Connector<? extends ConnectorRequest<?>>> C getConnectorById(String connectorId) {
        this.ensureConnectorProvidersInitialized();
        return (C)this.availableConnectors.get(connectorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ensureConnectorProvidersInitialized() {
        if (this.availableConnectors != null) return;
        Class<Connectors> clazz = Connectors.class;
        synchronized (Connectors.class) {
            if (this.availableConnectors != null) return;
            this.initializeConnectors(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void initializeConnectors(ClassLoader classLoader) {
        HashMap connectors = new HashMap();
        if (classLoader == null) {
            classLoader = Connectors.class.getClassLoader();
        }
        this.registerConnectors(connectors, classLoader);
        this.applyConfigurators(connectors, classLoader);
        this.availableConnectors = connectors;
    }

    protected void registerConnectors(Map<String, Connector<?>> connectors, ClassLoader classLoader) {
        ServiceLoader<ConnectorProvider> providers = ServiceLoader.load(ConnectorProvider.class, classLoader);
        for (ConnectorProvider provider : providers) {
            this.registerProvider(connectors, provider);
        }
    }

    protected void registerProvider(Map<String, Connector<?>> connectors, ConnectorProvider provider) {
        String connectorId = provider.getConnectorId();
        if (connectors.containsKey(connectorId)) {
            throw LOG.multipleConnectorProvidersFound(connectorId);
        }
        Connector<?> connectorInstance = provider.createConnectorInstance();
        LOG.connectorProviderDiscovered(provider, connectorId, connectorInstance);
        connectors.put(connectorId, connectorInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerConnectorInstance(String connectorId, Connector<?> connector) {
        this.ensureConnectorProvidersInitialized();
        Class<Connectors> clazz = Connectors.class;
        synchronized (Connectors.class) {
            this.availableConnectors.put(connectorId, connector);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterConnectorInstance(String connectorId) {
        this.ensureConnectorProvidersInitialized();
        Class<Connectors> clazz = Connectors.class;
        synchronized (Connectors.class) {
            this.availableConnectors.remove(connectorId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void applyConfigurators(Map<String, Connector<?>> connectors, ClassLoader classLoader) {
        ServiceLoader<ConnectorConfigurator> configurators = ServiceLoader.load(ConnectorConfigurator.class, classLoader);
        for (ConnectorConfigurator configurator : configurators) {
            LOG.connectorConfiguratorDiscovered(configurator);
            this.applyConfigurator(connectors, configurator);
        }
    }

    protected void applyConfigurator(Map<String, Connector<?>> connectors, ConnectorConfigurator configurator) {
        for (Connector<?> connector : connectors.values()) {
            if (!configurator.getConnectorClass().isAssignableFrom(connector.getClass())) continue;
            configurator.configure(connector);
        }
    }
}

