/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.impl;

import io.openbpm.connect.impl.AbstractConnectorResponse;
import io.openbpm.connect.impl.ConnectCoreLogger;
import io.openbpm.connect.impl.ConnectLogger;
import io.openbpm.connect.spi.CloseableConnectorResponse;
import java.io.Closeable;
import java.io.IOException;

public abstract class AbstractCloseableConnectorResponse
extends AbstractConnectorResponse
implements CloseableConnectorResponse {
    private static final ConnectCoreLogger LOG = ConnectLogger.CORE_LOGGER;

    @Override
    public void close() {
        Closeable closable = this.getClosable();
        try {
            LOG.closingResponse(this);
            closable.close();
            LOG.successfullyClosedResponse(this);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileClosingResponse(e);
        }
    }

    protected abstract Closeable getClosable();
}

