/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.impl;

import io.openbpm.connect.spi.Connector;
import io.openbpm.connect.spi.ConnectorRequest;
import io.openbpm.connect.spi.ConnectorRequestInterceptor;
import io.openbpm.connect.spi.ConnectorResponse;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractConnector<Q extends ConnectorRequest<R>, R extends ConnectorResponse>
implements Connector<Q> {
    protected String connectorId;
    protected List<ConnectorRequestInterceptor> requestInterceptors = new LinkedList<ConnectorRequestInterceptor>();

    protected AbstractConnector(String connectorId) {
        this.connectorId = connectorId;
    }

    @Override
    public String getId() {
        return this.connectorId;
    }

    @Override
    public List<ConnectorRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public void setRequestInterceptors(List<ConnectorRequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    @Override
    public Connector<Q> addRequestInterceptor(ConnectorRequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
        return this;
    }

    @Override
    public Connector<Q> addRequestInterceptors(Collection<ConnectorRequestInterceptor> interceptors) {
        this.requestInterceptors.addAll(interceptors);
        return this;
    }
}

