/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.client5.http.impl;

import connectjar.org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import connectjar.org.apache.hc.client5.http.config.RequestConfig;
import connectjar.org.apache.hc.client5.http.protocol.HttpClientContext;
import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.HeaderElement;
import connectjar.org.apache.hc.core5.http.HttpResponse;
import connectjar.org.apache.hc.core5.http.message.MessageSupport;
import connectjar.org.apache.hc.core5.http.protocol.HttpContext;
import connectjar.org.apache.hc.core5.util.Args;
import connectjar.org.apache.hc.core5.util.TimeValue;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Iterator<HeaderElement> it = MessageSupport.iterate(response, "keep-alive");
        while (it.hasNext()) {
            HeaderElement he = it.next();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return TimeValue.ofSeconds(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        return requestConfig.getConnectionKeepAlive();
    }
}

