/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.http.io.support;

import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.ClassicHttpRequest;
import connectjar.org.apache.hc.core5.http.ClassicHttpResponse;
import connectjar.org.apache.hc.core5.http.HttpException;
import connectjar.org.apache.hc.core5.http.HttpRequestMapper;
import connectjar.org.apache.hc.core5.http.HttpResponseFactory;
import connectjar.org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import connectjar.org.apache.hc.core5.http.io.HttpFilterChain;
import connectjar.org.apache.hc.core5.http.io.HttpFilterHandler;
import connectjar.org.apache.hc.core5.http.io.HttpRequestHandler;
import connectjar.org.apache.hc.core5.http.protocol.HttpContext;
import connectjar.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalServerFilter
implements HttpFilterHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public TerminalServerFilter(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Override
    public void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler handler = this.handlerMapper.resolve(request, context);
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

