/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.http2.protocol;

import connectjar.org.apache.hc.core5.annotation.Contract;
import connectjar.org.apache.hc.core5.annotation.Internal;
import connectjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import connectjar.org.apache.hc.core5.http.EntityDetails;
import connectjar.org.apache.hc.core5.http.Header;
import connectjar.org.apache.hc.core5.http.HttpException;
import connectjar.org.apache.hc.core5.http.HttpRequest;
import connectjar.org.apache.hc.core5.http.HttpRequestInterceptor;
import connectjar.org.apache.hc.core5.http.ProtocolException;
import connectjar.org.apache.hc.core5.http.protocol.HttpContext;
import connectjar.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2RequestConformance
implements HttpRequestInterceptor {
    public static final H2RequestConformance INSTANCE = new H2RequestConformance();
    private final String[] illegalHeaderNames;

    @Internal
    public H2RequestConformance(String ... illegalHeaderNames) {
        this.illegalHeaderNames = illegalHeaderNames;
    }

    public H2RequestConformance() {
        this("Connection", "Keep-Alive", "Proxy-Connection", "Transfer-Encoding", "Upgrade", "TE");
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext localContext) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        for (int i2 = 0; i2 < this.illegalHeaderNames.length; ++i2) {
            String headerName = this.illegalHeaderNames[i2];
            Header header = request.getFirstHeader(headerName);
            if (header == null) continue;
            if (headerName.equalsIgnoreCase("TE")) {
                String value = header.getValue();
                if ("trailers".equalsIgnoreCase(value)) continue;
                throw new ProtocolException("Header '%s: %s' is illegal for HTTP/2 messages", "TE", value);
            }
            throw new ProtocolException("Header '%s' is illegal for HTTP/2 messages", headerName);
        }
    }
}

